package io.dekorate.helm.config;

import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;

 /**
  * Generated
  */
  @Buildable(builderPackage = "io.fabric8.kubernetes.api.builder")
  public class HelmDependency{
  public HelmDependency() {
  }
  public HelmDependency(String name,String version,String repository,String condition,String[] tags,Boolean enabled,String alias) {
    this.name = name;
    this.version = version;
    this.repository = repository;
    this.condition = condition;
    this.tags = tags != null ? tags : new String[0];
    this.enabled = enabled;
    this.alias = alias;
  }
  private String name;
  private String version;
  private String repository;
  private String condition;
  private String[] tags = new String[0];
  private Boolean enabled;
  private String alias;
  public String getName() {
    return this.name;
  }
  public String getVersion() {
    return this.version;
  }
  public String getRepository() {
    return this.repository;
  }
  public String getCondition() {
    return this.condition;
  }
  public String[] getTags() {
    return this.tags;
  }
  public Boolean getEnabled() {
    return this.enabled;
  }
  public boolean isEnabled() {
    return this.enabled != null &&  this.enabled;
  }
  public String getAlias() {
    return this.alias;
  }
  public static HelmDependencyBuilder newBuilder() {
    return new HelmDependencyBuilder();
  }
  public static HelmDependencyBuilder newBuilderFromDefaults() {
    return new HelmDependencyBuilder().withEnabled(true);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HelmDependency that = (HelmDependency) o;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (version != null ? !version.equals(that.version) :that.version != null) return false;
    if (repository != null ? !repository.equals(that.repository) :that.repository != null) return false;
    if (condition != null ? !condition.equals(that.condition) :that.condition != null) return false;
    if (tags != null ? !tags.equals(that.tags) :that.tags != null) return false;
    if (enabled != null ? !enabled.equals(that.enabled) :that.enabled != null) return false;
    if (alias != null ? !alias.equals(that.alias) :that.alias != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(name,  version,  repository,  condition,  tags,  enabled,  alias,  super.hashCode());
  }
  
}