/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.helm.config;

import io.dekorate.helm.config.ValueReference;
import io.dekorate.helm.config.ValueReferenceFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ValueReferenceFluentImpl<A extends ValueReferenceFluent<A>>
extends BaseFluent<A>
implements ValueReferenceFluent<A> {
    private String property;
    private List<String> paths = new ArrayList<String>();
    private String profile;
    private String value;
    private String expression;

    public ValueReferenceFluentImpl() {
    }

    public ValueReferenceFluentImpl(ValueReference instance) {
        this.withProperty(instance.getProperty());
        this.withPaths(instance.getPaths());
        this.withProfile(instance.getProfile());
        this.withValue(instance.getValue());
        this.withExpression(instance.getExpression());
    }

    @Override
    public String getProperty() {
        return this.property;
    }

    @Override
    public A withProperty(String property) {
        this.property = property;
        return (A)this;
    }

    @Override
    public Boolean hasProperty() {
        return this.property != null;
    }

    @Override
    public A withPaths(String ... paths) {
        if (this.paths != null) {
            this.paths.clear();
        }
        if (paths != null) {
            for (String item : paths) {
                this.addToPaths(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getPaths() {
        int size = this.paths != null ? this.paths.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.paths) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToPaths(Integer index, String item) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        this.paths.add(index, item);
        return (A)this;
    }

    @Override
    public A setToPaths(Integer index, String item) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        this.paths.set(index, item);
        return (A)this;
    }

    @Override
    public A addToPaths(String ... items) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        for (String item : items) {
            this.paths.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToPaths(Collection<String> items) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        for (String item : items) {
            this.paths.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromPaths(String ... items) {
        for (String item : items) {
            if (this.paths == null) continue;
            this.paths.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPaths(Collection<String> items) {
        for (String item : items) {
            if (this.paths == null) continue;
            this.paths.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPaths() {
        return this.paths != null && !this.paths.isEmpty();
    }

    @Override
    public String getProfile() {
        return this.profile;
    }

    @Override
    public A withProfile(String profile) {
        this.profile = profile;
        return (A)this;
    }

    @Override
    public Boolean hasProfile() {
        return this.profile != null;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public A withValue(String value) {
        this.value = value;
        return (A)this;
    }

    @Override
    public Boolean hasValue() {
        return this.value != null;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public A withExpression(String expression) {
        this.expression = expression;
        return (A)this;
    }

    @Override
    public Boolean hasExpression() {
        return this.expression != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueReferenceFluentImpl that = (ValueReferenceFluentImpl)o;
        if (this.property != null ? !this.property.equals(that.property) : that.property != null) {
            return false;
        }
        if (this.paths != null ? !this.paths.equals(that.paths) : that.paths != null) {
            return false;
        }
        if (this.profile != null ? !this.profile.equals(that.profile) : that.profile != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        return !(this.expression != null ? !this.expression.equals(that.expression) : that.expression != null);
    }

    public int hashCode() {
        return Objects.hash(this.property, this.paths, this.profile, this.value, this.expression, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.property != null) {
            sb.append("property:");
            sb.append(this.property + ",");
        }
        if (this.paths != null && !this.paths.isEmpty()) {
            sb.append("paths:");
            sb.append(this.paths + ",");
        }
        if (this.profile != null) {
            sb.append("profile:");
            sb.append(this.profile + ",");
        }
        if (this.value != null) {
            sb.append("value:");
            sb.append(this.value + ",");
        }
        if (this.expression != null) {
            sb.append("expression:");
            sb.append(this.expression);
        }
        sb.append("}");
        return sb.toString();
    }
}

