package io.dekorate.helm.config;

import java.lang.Object;
import java.lang.String;
import io.sundr.builder.annotations.Buildable;

 /**
  * Generated
  */
  @Buildable(builderPackage = "io.fabric8.kubernetes.api.builder")
  public class ValueReference{
  public ValueReference() {
  }
  public ValueReference(String property,String[] paths,String profile,String value,String expression) {
    this.property = property;
    this.paths = paths != null ? paths : new String[0];
    this.profile = profile;
    this.value = value;
    this.expression = expression;
  }
  private String property;
  private String[] paths;
  private String profile;
  private String value;
  private String expression;
  public String getProperty() {
    return this.property;
  }
  
  /**
   * The path expressions where to map the property.
   */
public String[] getPaths() {
    return this.paths;
  }
  public String getProfile() {
    return this.profile;
  }
  public String getValue() {
    return this.value;
  }
  
  /**
   * If not provided, it will use `{{ .Values.<root alias>.<property> }}`.
   * @return The complete Helm expression to be replaced with.
   */
public String getExpression() {
    return this.expression;
  }
  public static ValueReferenceBuilder newBuilder() {
    return new ValueReferenceBuilder();
  }
  public static ValueReferenceBuilder newBuilderFromDefaults() {
    return new ValueReferenceBuilder();
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ValueReference that = (ValueReference) o;
    if (property != null ? !property.equals(that.property) :that.property != null) return false;
    if (paths != null ? !paths.equals(that.paths) :that.paths != null) return false;
    if (profile != null ? !profile.equals(that.profile) :that.profile != null) return false;
    if (value != null ? !value.equals(that.value) :that.value != null) return false;
    if (expression != null ? !expression.equals(that.expression) :that.expression != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(property,  paths,  profile,  value,  expression,  super.hashCode());
  }
  
}