package io.dekorate.helm.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;

 /**
  * Generated
  */
public class HelmExpressionBuilder extends HelmExpressionFluentImpl<HelmExpressionBuilder> implements VisitableBuilder<HelmExpression,HelmExpressionBuilder>{
  public HelmExpressionBuilder() {
    this(false);
  }
  public HelmExpressionBuilder(Boolean validationEnabled) {
    this(new HelmExpression(), validationEnabled);
  }
  public HelmExpressionBuilder(HelmExpressionFluent<?> fluent) {
    this(fluent, false);
  }
  public HelmExpressionBuilder(HelmExpressionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HelmExpression(), validationEnabled);
  }
  public HelmExpressionBuilder(HelmExpressionFluent<?> fluent,HelmExpression instance) {
    this(fluent, instance, false);
  }
  public HelmExpressionBuilder(HelmExpressionFluent<?> fluent,HelmExpression instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withPath(instance.getPath()); 
    fluent.withExpression(instance.getExpression()); 
    this.validationEnabled = validationEnabled; 
  }
  public HelmExpressionBuilder(HelmExpression instance) {
    this(instance,false);
  }
  public HelmExpressionBuilder(HelmExpression instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withPath(instance.getPath()); 
    this.withExpression(instance.getExpression()); 
    this.validationEnabled = validationEnabled; 
  }
  HelmExpressionFluent<?> fluent;
  Boolean validationEnabled;
  public EditableHelmExpression build() {
    EditableHelmExpression buildable = new EditableHelmExpression(fluent.getPath(),fluent.getExpression());
    return buildable;
  }
  
}