package io.dekorate.helm.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;

 /**
  * Generated
  */
public class HelmDependencyBuilder extends HelmDependencyFluentImpl<HelmDependencyBuilder> implements VisitableBuilder<HelmDependency,HelmDependencyBuilder>{
  public HelmDependencyBuilder() {
    this(false);
  }
  public HelmDependencyBuilder(Boolean validationEnabled) {
    this(new HelmDependency(), validationEnabled);
  }
  public HelmDependencyBuilder(HelmDependencyFluent<?> fluent) {
    this(fluent, false);
  }
  public HelmDependencyBuilder(HelmDependencyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HelmDependency(), validationEnabled);
  }
  public HelmDependencyBuilder(HelmDependencyFluent<?> fluent,HelmDependency instance) {
    this(fluent, instance, false);
  }
  public HelmDependencyBuilder(HelmDependencyFluent<?> fluent,HelmDependency instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withVersion(instance.getVersion()); 
    fluent.withRepository(instance.getRepository()); 
    fluent.withCondition(instance.getCondition()); 
    fluent.withTags(instance.getTags()); 
    fluent.withEnabled(instance.getEnabled()); 
    fluent.withAlias(instance.getAlias()); 
    this.validationEnabled = validationEnabled; 
  }
  public HelmDependencyBuilder(HelmDependency instance) {
    this(instance,false);
  }
  public HelmDependencyBuilder(HelmDependency instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withVersion(instance.getVersion()); 
    this.withRepository(instance.getRepository()); 
    this.withCondition(instance.getCondition()); 
    this.withTags(instance.getTags()); 
    this.withEnabled(instance.getEnabled()); 
    this.withAlias(instance.getAlias()); 
    this.validationEnabled = validationEnabled; 
  }
  HelmDependencyFluent<?> fluent;
  Boolean validationEnabled;
  public EditableHelmDependency build() {
    EditableHelmDependency buildable = new EditableHelmDependency(fluent.getName(),fluent.getVersion(),fluent.getRepository(),fluent.getCondition(),fluent.getTags(),fluent.getEnabled(),fluent.getAlias());
    return buildable;
  }
  
}