/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.helm.config;

import io.dekorate.helm.config.HelmDependencyBuilder;
import java.util.Objects;

public class HelmDependency {
    private String name;
    private String version;
    private String repository;
    private String condition;
    private String[] tags = new String[0];
    private Boolean enabled;
    private String alias;

    public HelmDependency() {
    }

    public HelmDependency(String name, String version, String repository, String condition, String[] tags, Boolean enabled, String alias) {
        this.name = name;
        this.version = version;
        this.repository = repository;
        this.condition = condition;
        this.tags = tags != null ? tags : new String[]{};
        this.enabled = enabled;
        this.alias = alias;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getCondition() {
        return this.condition;
    }

    public String[] getTags() {
        return this.tags;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public boolean isEnabled() {
        return this.enabled != null && this.enabled != false;
    }

    public String getAlias() {
        return this.alias;
    }

    public static HelmDependencyBuilder newBuilder() {
        return new HelmDependencyBuilder();
    }

    public static HelmDependencyBuilder newBuilderFromDefaults() {
        return (HelmDependencyBuilder)new HelmDependencyBuilder().withEnabled(true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HelmDependency that = (HelmDependency)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        if (this.repository != null ? !this.repository.equals(that.repository) : that.repository != null) {
            return false;
        }
        if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) {
            return false;
        }
        if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) {
            return false;
        }
        if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) {
            return false;
        }
        return !(this.alias != null ? !this.alias.equals(that.alias) : that.alias != null);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.repository, this.condition, this.tags, this.enabled, this.alias, super.hashCode());
    }
}

