package io.dekorate.helm.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.dekorate.kubernetes.config.ConfigurationFluent;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.dekorate.kubernetes.config.ConfigKey;
import java.lang.Integer;
import io.dekorate.project.Project;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface HelmChartConfigFluent<A extends HelmChartConfigFluent<A>> extends ConfigurationFluent<A>{
  public Boolean getEnabled();
  public A withEnabled(Boolean enabled);
  public Boolean hasEnabled();
  public String getName();
  public A withName(String name);
  public Boolean hasName();
  public String getHome();
  public A withHome(String home);
  public Boolean hasHome();
  public A withSources(java.lang.String... sources);
  public String[] getSources();
  public A addToSources(Integer index,String item);
  public A setToSources(Integer index,String item);
  public A addToSources(java.lang.String... items);
  public A addAllToSources(Collection<String> items);
  public A removeFromSources(java.lang.String... items);
  public A removeAllFromSources(Collection<String> items);
  public Boolean hasSources();
  public String getVersion();
  public A withVersion(String version);
  public Boolean hasVersion();
  public String getDescription();
  public A withDescription(String description);
  public Boolean hasDescription();
  public A withKeywords(java.lang.String... keywords);
  public String[] getKeywords();
  public A addToKeywords(Integer index,String item);
  public A setToKeywords(Integer index,String item);
  public A addToKeywords(java.lang.String... items);
  public A addAllToKeywords(Collection<String> items);
  public A removeFromKeywords(java.lang.String... items);
  public A removeAllFromKeywords(Collection<String> items);
  public Boolean hasKeywords();
  public A withMaintainers(io.dekorate.helm.config.Maintainer... maintainers);
  
  /**
   * This method has been deprecated, please use method buildMaintainers instead.
   */
  @Deprecated
  public Maintainer[] getMaintainers();
  public Maintainer[] buildMaintainers();
  public Maintainer buildMaintainer(Integer index);
  public Maintainer buildFirstMaintainer();
  public Maintainer buildLastMaintainer();
  public Maintainer buildMatchingMaintainer(Predicate<MaintainerBuilder> predicate);
  public Boolean hasMatchingMaintainer(Predicate<MaintainerBuilder> predicate);
  public A addToMaintainers(Integer index,Maintainer item);
  public A setToMaintainers(Integer index,Maintainer item);
  public A addToMaintainers(io.dekorate.helm.config.Maintainer... items);
  public A addAllToMaintainers(Collection<Maintainer> items);
  public A removeFromMaintainers(io.dekorate.helm.config.Maintainer... items);
  public A removeAllFromMaintainers(Collection<Maintainer> items);
  public A removeMatchingFromMaintainers(Predicate<MaintainerBuilder> predicate);
  public Boolean hasMaintainers();
  public A addNewMaintainer(String name,String email,String url);
  public HelmChartConfigFluent.MaintainersNested<A> addNewMaintainer();
  public HelmChartConfigFluent.MaintainersNested<A> addNewMaintainerLike(Maintainer item);
  public HelmChartConfigFluent.MaintainersNested<A> setNewMaintainerLike(Integer index,Maintainer item);
  public HelmChartConfigFluent.MaintainersNested<A> editMaintainer(Integer index);
  public HelmChartConfigFluent.MaintainersNested<A> editFirstMaintainer();
  public HelmChartConfigFluent.MaintainersNested<A> editLastMaintainer();
  public HelmChartConfigFluent.MaintainersNested<A> editMatchingMaintainer(Predicate<MaintainerBuilder> predicate);
  public String getIcon();
  public A withIcon(String icon);
  public Boolean hasIcon();
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getCondition();
  public A withCondition(String condition);
  public Boolean hasCondition();
  public String getTags();
  public A withTags(String tags);
  public Boolean hasTags();
  public String getAppVersion();
  public A withAppVersion(String appVersion);
  public Boolean hasAppVersion();
  public Boolean getDeprecated();
  public A withDeprecated(Boolean deprecated);
  public Boolean hasDeprecated();
  public A withAnnotations(io.dekorate.helm.config.Annotation... annotations);
  
  /**
   * This method has been deprecated, please use method buildAnnotations instead.
   */
  @Deprecated
  public Annotation[] getAnnotations();
  public Annotation[] buildAnnotations();
  public Annotation buildAnnotation(Integer index);
  public Annotation buildFirstAnnotation();
  public Annotation buildLastAnnotation();
  public Annotation buildMatchingAnnotation(Predicate<AnnotationBuilder> predicate);
  public Boolean hasMatchingAnnotation(Predicate<AnnotationBuilder> predicate);
  public A addToAnnotations(Integer index,Annotation item);
  public A setToAnnotations(Integer index,Annotation item);
  public A addToAnnotations(io.dekorate.helm.config.Annotation... items);
  public A addAllToAnnotations(Collection<Annotation> items);
  public A removeFromAnnotations(io.dekorate.helm.config.Annotation... items);
  public A removeAllFromAnnotations(Collection<Annotation> items);
  public A removeMatchingFromAnnotations(Predicate<AnnotationBuilder> predicate);
  public Boolean hasAnnotations();
  public A addNewAnnotation(String key,String value);
  public HelmChartConfigFluent.AnnotationsNested<A> addNewAnnotation();
  public HelmChartConfigFluent.AnnotationsNested<A> addNewAnnotationLike(Annotation item);
  public HelmChartConfigFluent.AnnotationsNested<A> setNewAnnotationLike(Integer index,Annotation item);
  public HelmChartConfigFluent.AnnotationsNested<A> editAnnotation(Integer index);
  public HelmChartConfigFluent.AnnotationsNested<A> editFirstAnnotation();
  public HelmChartConfigFluent.AnnotationsNested<A> editLastAnnotation();
  public HelmChartConfigFluent.AnnotationsNested<A> editMatchingAnnotation(Predicate<AnnotationBuilder> predicate);
  public String getKubeVersion();
  public A withKubeVersion(String kubeVersion);
  public Boolean hasKubeVersion();
  public A withDependencies(io.dekorate.helm.config.HelmDependency... dependencies);
  
  /**
   * This method has been deprecated, please use method buildDependencies instead.
   */
  @Deprecated
  public HelmDependency[] getDependencies();
  public HelmDependency[] buildDependencies();
  public HelmDependency buildDependency(Integer index);
  public HelmDependency buildFirstDependency();
  public HelmDependency buildLastDependency();
  public HelmDependency buildMatchingDependency(Predicate<HelmDependencyBuilder> predicate);
  public Boolean hasMatchingDependency(Predicate<HelmDependencyBuilder> predicate);
  public A addToDependencies(Integer index,HelmDependency item);
  public A setToDependencies(Integer index,HelmDependency item);
  public A addToDependencies(io.dekorate.helm.config.HelmDependency... items);
  public A addAllToDependencies(Collection<HelmDependency> items);
  public A removeFromDependencies(io.dekorate.helm.config.HelmDependency... items);
  public A removeAllFromDependencies(Collection<HelmDependency> items);
  public A removeMatchingFromDependencies(Predicate<HelmDependencyBuilder> predicate);
  public Boolean hasDependencies();
  public HelmChartConfigFluent.DependenciesNested<A> addNewDependency();
  public HelmChartConfigFluent.DependenciesNested<A> addNewDependencyLike(HelmDependency item);
  public HelmChartConfigFluent.DependenciesNested<A> setNewDependencyLike(Integer index,HelmDependency item);
  public HelmChartConfigFluent.DependenciesNested<A> editDependency(Integer index);
  public HelmChartConfigFluent.DependenciesNested<A> editFirstDependency();
  public HelmChartConfigFluent.DependenciesNested<A> editLastDependency();
  public HelmChartConfigFluent.DependenciesNested<A> editMatchingDependency(Predicate<HelmDependencyBuilder> predicate);
  public String getType();
  public A withType(String type);
  public Boolean hasType();
  public String getValuesRootAlias();
  public A withValuesRootAlias(String valuesRootAlias);
  public Boolean hasValuesRootAlias();
  public Boolean getCreateTarFile();
  public A withCreateTarFile(Boolean createTarFile);
  public Boolean hasCreateTarFile();
  public String getExtension();
  public A withExtension(String extension);
  public Boolean hasExtension();
  public String getTarFileClassifier();
  public A withTarFileClassifier(String tarFileClassifier);
  public Boolean hasTarFileClassifier();
  public String getNotes();
  public A withNotes(String notes);
  public Boolean hasNotes();
  public String getInputFolder();
  public A withInputFolder(String inputFolder);
  public Boolean hasInputFolder();
  public String getOutputFolder();
  public A withOutputFolder(String outputFolder);
  public Boolean hasOutputFolder();
  public A withValues(io.dekorate.helm.config.ValueReference... values);
  
  /**
   * This method has been deprecated, please use method buildValues instead.
   */
  @Deprecated
  public ValueReference[] getValues();
  public ValueReference[] buildValues();
  public ValueReference buildValue(Integer index);
  public ValueReference buildFirstValue();
  public ValueReference buildLastValue();
  public ValueReference buildMatchingValue(Predicate<ValueReferenceBuilder> predicate);
  public Boolean hasMatchingValue(Predicate<ValueReferenceBuilder> predicate);
  public A addToValues(Integer index,ValueReference item);
  public A setToValues(Integer index,ValueReference item);
  public A addToValues(io.dekorate.helm.config.ValueReference... items);
  public A addAllToValues(Collection<ValueReference> items);
  public A removeFromValues(io.dekorate.helm.config.ValueReference... items);
  public A removeAllFromValues(Collection<ValueReference> items);
  public A removeMatchingFromValues(Predicate<ValueReferenceBuilder> predicate);
  public Boolean hasValues();
  public A addNewValue(String property,String[] paths,String profile,String value,String expression);
  public HelmChartConfigFluent.ValuesNested<A> addNewValue();
  public HelmChartConfigFluent.ValuesNested<A> addNewValueLike(ValueReference item);
  public HelmChartConfigFluent.ValuesNested<A> setNewValueLike(Integer index,ValueReference item);
  public HelmChartConfigFluent.ValuesNested<A> editValue(Integer index);
  public HelmChartConfigFluent.ValuesNested<A> editFirstValue();
  public HelmChartConfigFluent.ValuesNested<A> editLastValue();
  public HelmChartConfigFluent.ValuesNested<A> editMatchingValue(Predicate<ValueReferenceBuilder> predicate);
  public A withExpressions(io.dekorate.helm.config.HelmExpression... expressions);
  
  /**
   * This method has been deprecated, please use method buildExpressions instead.
   */
  @Deprecated
  public HelmExpression[] getExpressions();
  public HelmExpression[] buildExpressions();
  public HelmExpression buildExpression(Integer index);
  public HelmExpression buildFirstExpression();
  public HelmExpression buildLastExpression();
  public HelmExpression buildMatchingExpression(Predicate<HelmExpressionBuilder> predicate);
  public Boolean hasMatchingExpression(Predicate<HelmExpressionBuilder> predicate);
  public A addToExpressions(Integer index,HelmExpression item);
  public A setToExpressions(Integer index,HelmExpression item);
  public A addToExpressions(io.dekorate.helm.config.HelmExpression... items);
  public A addAllToExpressions(Collection<HelmExpression> items);
  public A removeFromExpressions(io.dekorate.helm.config.HelmExpression... items);
  public A removeAllFromExpressions(Collection<HelmExpression> items);
  public A removeMatchingFromExpressions(Predicate<HelmExpressionBuilder> predicate);
  public Boolean hasExpressions();
  public A addNewExpression(String path,String expression);
  public HelmChartConfigFluent.ExpressionsNested<A> addNewExpression();
  public HelmChartConfigFluent.ExpressionsNested<A> addNewExpressionLike(HelmExpression item);
  public HelmChartConfigFluent.ExpressionsNested<A> setNewExpressionLike(Integer index,HelmExpression item);
  public HelmChartConfigFluent.ExpressionsNested<A> editExpression(Integer index);
  public HelmChartConfigFluent.ExpressionsNested<A> editFirstExpression();
  public HelmChartConfigFluent.ExpressionsNested<A> editLastExpression();
  public HelmChartConfigFluent.ExpressionsNested<A> editMatchingExpression(Predicate<HelmExpressionBuilder> predicate);
  public A withAddIfStatements(io.dekorate.helm.config.AddIfStatement... addIfStatements);
  
  /**
   * This method has been deprecated, please use method buildAddIfStatements instead.
   */
  @Deprecated
  public AddIfStatement[] getAddIfStatements();
  public AddIfStatement[] buildAddIfStatements();
  public AddIfStatement buildAddIfStatement(Integer index);
  public AddIfStatement buildFirstAddIfStatement();
  public AddIfStatement buildLastAddIfStatement();
  public AddIfStatement buildMatchingAddIfStatement(Predicate<AddIfStatementBuilder> predicate);
  public Boolean hasMatchingAddIfStatement(Predicate<AddIfStatementBuilder> predicate);
  public A addToAddIfStatements(Integer index,AddIfStatement item);
  public A setToAddIfStatements(Integer index,AddIfStatement item);
  public A addToAddIfStatements(io.dekorate.helm.config.AddIfStatement... items);
  public A addAllToAddIfStatements(Collection<AddIfStatement> items);
  public A removeFromAddIfStatements(io.dekorate.helm.config.AddIfStatement... items);
  public A removeAllFromAddIfStatements(Collection<AddIfStatement> items);
  public A removeMatchingFromAddIfStatements(Predicate<AddIfStatementBuilder> predicate);
  public Boolean hasAddIfStatements();
  public A addNewAddIfStatement(String property,String onResourceKind,String onResourceName,Boolean withDefaultValue);
  public HelmChartConfigFluent.AddIfStatementsNested<A> addNewAddIfStatement();
  public HelmChartConfigFluent.AddIfStatementsNested<A> addNewAddIfStatementLike(AddIfStatement item);
  public HelmChartConfigFluent.AddIfStatementsNested<A> setNewAddIfStatementLike(Integer index,AddIfStatement item);
  public HelmChartConfigFluent.AddIfStatementsNested<A> editAddIfStatement(Integer index);
  public HelmChartConfigFluent.AddIfStatementsNested<A> editFirstAddIfStatement();
  public HelmChartConfigFluent.AddIfStatementsNested<A> editLastAddIfStatement();
  public HelmChartConfigFluent.AddIfStatementsNested<A> editMatchingAddIfStatement(Predicate<AddIfStatementBuilder> predicate);
  public A withEnabled();
  public A withDeprecated();
  public A withCreateTarFile();
  public interface MaintainersNested<N> extends Nested<N>,MaintainerFluent<HelmChartConfigFluent.MaintainersNested<N>>{
    public N and();
    public N endMaintainer();
    
  }
  public interface AnnotationsNested<N> extends Nested<N>,AnnotationFluent<HelmChartConfigFluent.AnnotationsNested<N>>{
    public N and();
    public N endAnnotation();
    
  }
  public interface DependenciesNested<N> extends Nested<N>,HelmDependencyFluent<HelmChartConfigFluent.DependenciesNested<N>>{
    public N and();
    public N endDependency();
    
  }
  public interface ValuesNested<N> extends Nested<N>,ValueReferenceFluent<HelmChartConfigFluent.ValuesNested<N>>{
    public N and();
    public N endValue();
    
  }
  public interface ExpressionsNested<N> extends Nested<N>,HelmExpressionFluent<HelmChartConfigFluent.ExpressionsNested<N>>{
    public N and();
    public N endExpression();
    
  }
  public interface AddIfStatementsNested<N> extends Nested<N>,AddIfStatementFluent<HelmChartConfigFluent.AddIfStatementsNested<N>>{
    public N and();
    public N endAddIfStatement();
    
  }
  
}