package io.dekorate.helm.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;

 /**
  * Generated
  */
public class HelmDependencyBuilder extends HelmDependencyFluentImpl<HelmDependencyBuilder> implements VisitableBuilder<HelmDependency,HelmDependencyBuilder>{
  public HelmDependencyBuilder() {
    this(false);
  }
  public HelmDependencyBuilder(Boolean validationEnabled) {
    this(new HelmDependency(), validationEnabled);
  }
  public HelmDependencyBuilder(HelmDependencyFluent<?> fluent) {
    this(fluent, false);
  }
  public HelmDependencyBuilder(HelmDependencyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HelmDependency(), validationEnabled);
  }
  public HelmDependencyBuilder(HelmDependencyFluent<?> fluent,HelmDependency instance) {
    this(fluent, instance, false);
  }
  public HelmDependencyBuilder(HelmDependencyFluent<?> fluent,HelmDependency instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withAlias(instance.getAlias()); 
    fluent.withVersion(instance.getVersion()); 
    fluent.withRepository(instance.getRepository()); 
    fluent.withCondition(instance.getCondition()); 
    fluent.withTags(instance.getTags()); 
    this.validationEnabled = validationEnabled; 
  }
  public HelmDependencyBuilder(HelmDependency instance) {
    this(instance,false);
  }
  public HelmDependencyBuilder(HelmDependency instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withAlias(instance.getAlias()); 
    this.withVersion(instance.getVersion()); 
    this.withRepository(instance.getRepository()); 
    this.withCondition(instance.getCondition()); 
    this.withTags(instance.getTags()); 
    this.validationEnabled = validationEnabled; 
  }
  HelmDependencyFluent<?> fluent;
  Boolean validationEnabled;
  public EditableHelmDependency build() {
    EditableHelmDependency buildable = new EditableHelmDependency(fluent.getName(),fluent.getAlias(),fluent.getVersion(),fluent.getRepository(),fluent.getCondition(),fluent.getTags());
    return buildable;
  }
  
}