package io.dekorate.helm.config;

import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.Configuration;
import java.lang.String;
import io.dekorate.project.Project;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

 /**
  * Generated
  */
  @Buildable(builderPackage = "io.fabric8.kubernetes.api.builder")
  public class HelmChartConfig extends Configuration{
  public HelmChartConfig() {
  }
  public HelmChartConfig(Project project,Map<ConfigKey,Object> attributes,Boolean enabled,String name,String apiVersion,String valuesRootAlias,String description,String version,String icon,String home,String[] keywords,String[] sources,Boolean createTarFile,String extension,String tarFileClassifier,String notes,String inputFolder,String outputFolder,Maintainer[] maintainers,HelmDependency[] dependencies,ValueReference[] values,HelmExpression[] expressions) {
    super(project, attributes);
    this.enabled = enabled;
    this.name = name;
    this.apiVersion = apiVersion;
    this.valuesRootAlias = valuesRootAlias;
    this.description = description;
    this.version = version;
    this.icon = icon;
    this.home = home;
    this.keywords = keywords != null ? keywords : new String[0];
    this.sources = sources != null ? sources : new String[0];
    this.createTarFile = createTarFile;
    this.extension = extension;
    this.tarFileClassifier = tarFileClassifier;
    this.notes = notes;
    this.inputFolder = inputFolder;
    this.outputFolder = outputFolder;
    this.maintainers = maintainers != null ? maintainers : new Maintainer[0];
    this.dependencies = dependencies != null ? dependencies : new HelmDependency[0];
    this.values = values != null ? values : new ValueReference[0];
    this.expressions = expressions != null ? expressions : new HelmExpression[0];
  }
  private Boolean enabled;
  private String name;
  private String apiVersion;
  private String valuesRootAlias;
  private String description;
  private String version;
  private String icon;
  private String home;
  private String[] keywords = new String[0];
  private String[] sources = new String[0];
  private Boolean createTarFile;
  private String extension;
  private String tarFileClassifier;
  private String notes;
  private String inputFolder;
  private String outputFolder;
  private Maintainer[] maintainers = new Maintainer[0];
  private HelmDependency[] dependencies = new HelmDependency[0];
  private ValueReference[] values = new ValueReference[0];
  private HelmExpression[] expressions = new HelmExpression[0];
  public Boolean getEnabled() {
    return this.enabled;
  }
  public boolean isEnabled() {
    return this.enabled != null &&  this.enabled;
  }
  public String getName() {
    return this.name;
  }
  public String getApiVersion() {
    return this.apiVersion;
  }
  public String getValuesRootAlias() {
    return this.valuesRootAlias;
  }
  public String getDescription() {
    return this.description;
  }
  public String getVersion() {
    return this.version;
  }
  public String getIcon() {
    return this.icon;
  }
  public String getHome() {
    return this.home;
  }
  public String[] getKeywords() {
    return this.keywords;
  }
  public String[] getSources() {
    return this.sources;
  }
  public Boolean getCreateTarFile() {
    return this.createTarFile;
  }
  public boolean isCreateTarFile() {
    return this.createTarFile != null &&  this.createTarFile;
  }
  public String getExtension() {
    return this.extension;
  }
  public String getTarFileClassifier() {
    return this.tarFileClassifier;
  }
  public String getNotes() {
    return this.notes;
  }
  public String getInputFolder() {
    return this.inputFolder;
  }
  public String getOutputFolder() {
    return this.outputFolder;
  }
  public Maintainer[] getMaintainers() {
    return this.maintainers;
  }
  public HelmDependency[] getDependencies() {
    return this.dependencies;
  }
  public ValueReference[] getValues() {
    return this.values;
  }
  public HelmExpression[] getExpressions() {
    return this.expressions;
  }
  public static HelmChartConfigBuilder newHelmChartConfigBuilder() {
    return new HelmChartConfigBuilder();
  }
  public static HelmChartConfigBuilder newHelmChartConfigBuilderFromDefaults() {
    return new HelmChartConfigBuilder().withEnabled(true).withApiVersion("v2").withValuesRootAlias("app").withCreateTarFile(false).withExtension("tar.gz").withNotes("/NOTES.template.txt").withInputFolder("helm").withOutputFolder("helm");
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HelmChartConfig that = (HelmChartConfig) o;
    if (enabled != null ? !enabled.equals(that.enabled) :that.enabled != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (valuesRootAlias != null ? !valuesRootAlias.equals(that.valuesRootAlias) :that.valuesRootAlias != null) return false;
    if (description != null ? !description.equals(that.description) :that.description != null) return false;
    if (version != null ? !version.equals(that.version) :that.version != null) return false;
    if (icon != null ? !icon.equals(that.icon) :that.icon != null) return false;
    if (home != null ? !home.equals(that.home) :that.home != null) return false;
    if (keywords != null ? !keywords.equals(that.keywords) :that.keywords != null) return false;
    if (sources != null ? !sources.equals(that.sources) :that.sources != null) return false;
    if (createTarFile != null ? !createTarFile.equals(that.createTarFile) :that.createTarFile != null) return false;
    if (extension != null ? !extension.equals(that.extension) :that.extension != null) return false;
    if (tarFileClassifier != null ? !tarFileClassifier.equals(that.tarFileClassifier) :that.tarFileClassifier != null) return false;
    if (notes != null ? !notes.equals(that.notes) :that.notes != null) return false;
    if (inputFolder != null ? !inputFolder.equals(that.inputFolder) :that.inputFolder != null) return false;
    if (outputFolder != null ? !outputFolder.equals(that.outputFolder) :that.outputFolder != null) return false;
    if (maintainers != null ? !maintainers.equals(that.maintainers) :that.maintainers != null) return false;
    if (dependencies != null ? !dependencies.equals(that.dependencies) :that.dependencies != null) return false;
    if (values != null ? !values.equals(that.values) :that.values != null) return false;
    if (expressions != null ? !expressions.equals(that.expressions) :that.expressions != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(enabled,  name,  apiVersion,  valuesRootAlias,  description,  version,  icon,  home,  keywords,  sources,  createTarFile,  extension,  tarFileClassifier,  notes,  inputFolder,  outputFolder,  maintainers,  dependencies,  values,  expressions,  super.hashCode());
  }
  
}