package io.dekorate.helm.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.dekorate.kubernetes.config.ConfigurationFluentImpl;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class HelmChartConfigFluentImpl<A extends HelmChartConfigFluent<A>> extends ConfigurationFluentImpl<A> implements HelmChartConfigFluent<A>{
  public HelmChartConfigFluentImpl() {
  }
  public HelmChartConfigFluentImpl(HelmChartConfig instance) {
    this.withProject(instance.getProject()); 
    this.withAttributes(instance.getAttributes()); 
    this.withEnabled(instance.getEnabled()); 
    this.withName(instance.getName()); 
    this.withApiVersion(instance.getApiVersion()); 
    this.withValuesRootAlias(instance.getValuesRootAlias()); 
    this.withDescription(instance.getDescription()); 
    this.withVersion(instance.getVersion()); 
    this.withIcon(instance.getIcon()); 
    this.withHome(instance.getHome()); 
    this.withKeywords(instance.getKeywords()); 
    this.withSources(instance.getSources()); 
    this.withCreateTarFile(instance.getCreateTarFile()); 
    this.withExtension(instance.getExtension()); 
    this.withNotes(instance.getNotes()); 
    this.withInputFolder(instance.getInputFolder()); 
    this.withOutputFolder(instance.getOutputFolder()); 
    this.withMaintainers(instance.getMaintainers()); 
    this.withDependencies(instance.getDependencies()); 
    this.withValues(instance.getValues()); 
    this.withExpressions(instance.getExpressions()); 
  }
  private Boolean enabled;
  private String name;
  private String apiVersion;
  private String valuesRootAlias;
  private String description;
  private String version;
  private String icon;
  private String home;
  private List<String> keywords = new ArrayList<String>();
  private List<String> sources = new ArrayList<String>();
  private Boolean createTarFile;
  private String extension;
  private String notes;
  private String inputFolder;
  private String outputFolder;
  private ArrayList<MaintainerBuilder> maintainers = new ArrayList<MaintainerBuilder>();
  private ArrayList<HelmDependencyBuilder> dependencies = new ArrayList<HelmDependencyBuilder>();
  private ArrayList<ValueReferenceBuilder> values = new ArrayList<ValueReferenceBuilder>();
  private ArrayList<HelmExpressionBuilder> expressions = new ArrayList<HelmExpressionBuilder>();
  public Boolean getEnabled() {
    return this.enabled;
  }
  public A withEnabled(Boolean enabled) {
    this.enabled=enabled; return (A) this;
  }
  public Boolean hasEnabled() {
    return this.enabled != null;
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getValuesRootAlias() {
    return this.valuesRootAlias;
  }
  public A withValuesRootAlias(String valuesRootAlias) {
    this.valuesRootAlias=valuesRootAlias; return (A) this;
  }
  public Boolean hasValuesRootAlias() {
    return this.valuesRootAlias != null;
  }
  public String getDescription() {
    return this.description;
  }
  public A withDescription(String description) {
    this.description=description; return (A) this;
  }
  public Boolean hasDescription() {
    return this.description != null;
  }
  public String getVersion() {
    return this.version;
  }
  public A withVersion(String version) {
    this.version=version; return (A) this;
  }
  public Boolean hasVersion() {
    return this.version != null;
  }
  public String getIcon() {
    return this.icon;
  }
  public A withIcon(String icon) {
    this.icon=icon; return (A) this;
  }
  public Boolean hasIcon() {
    return this.icon != null;
  }
  public String getHome() {
    return this.home;
  }
  public A withHome(String home) {
    this.home=home; return (A) this;
  }
  public Boolean hasHome() {
    return this.home != null;
  }
  public A withKeywords(java.lang.String... keywords) {
    if (this.keywords != null) {this.keywords.clear();}
    if (keywords != null) {for (String item :keywords){ this.addToKeywords(item);}} return (A) this;
  }
  public String[] getKeywords() {
    //This needs to work with primitives, so we use arrays.
int size = keywords != null ? keywords.size() : 0;
String[] result = new String[size];
if (size == 0) {
   return result;
}
int index = 0;
for (String item : keywords) {
    result[index++]=item;
}
return result;

  }
  public A addToKeywords(Integer index,String item) {
    if (this.keywords == null) {this.keywords = new ArrayList<String>();}
    this.keywords.add(index, item);
    return (A)this;
  }
  public A setToKeywords(Integer index,String item) {
    if (this.keywords == null) {this.keywords = new ArrayList<String>();}
    this.keywords.set(index, item); return (A)this;
  }
  public A addToKeywords(java.lang.String... items) {
    if (this.keywords == null) {this.keywords = new ArrayList<String>();}
    for (String item : items) {this.keywords.add(item);} return (A)this;
  }
  public A addAllToKeywords(Collection<String> items) {
    if (this.keywords == null) {this.keywords = new ArrayList<String>();}
    for (String item : items) {this.keywords.add(item);} return (A)this;
  }
  public A removeFromKeywords(java.lang.String... items) {
    for (String item : items) {if (this.keywords!= null){ this.keywords.remove(item);}} return (A)this;
  }
  public A removeAllFromKeywords(Collection<String> items) {
    for (String item : items) {if (this.keywords!= null){ this.keywords.remove(item);}} return (A)this;
  }
  public Boolean hasKeywords() {
    return keywords != null && !keywords.isEmpty();
  }
  public A withSources(java.lang.String... sources) {
    if (this.sources != null) {this.sources.clear();}
    if (sources != null) {for (String item :sources){ this.addToSources(item);}} return (A) this;
  }
  public String[] getSources() {
    //This needs to work with primitives, so we use arrays.
int size = sources != null ? sources.size() : 0;
String[] result = new String[size];
if (size == 0) {
   return result;
}
int index = 0;
for (String item : sources) {
    result[index++]=item;
}
return result;

  }
  public A addToSources(Integer index,String item) {
    if (this.sources == null) {this.sources = new ArrayList<String>();}
    this.sources.add(index, item);
    return (A)this;
  }
  public A setToSources(Integer index,String item) {
    if (this.sources == null) {this.sources = new ArrayList<String>();}
    this.sources.set(index, item); return (A)this;
  }
  public A addToSources(java.lang.String... items) {
    if (this.sources == null) {this.sources = new ArrayList<String>();}
    for (String item : items) {this.sources.add(item);} return (A)this;
  }
  public A addAllToSources(Collection<String> items) {
    if (this.sources == null) {this.sources = new ArrayList<String>();}
    for (String item : items) {this.sources.add(item);} return (A)this;
  }
  public A removeFromSources(java.lang.String... items) {
    for (String item : items) {if (this.sources!= null){ this.sources.remove(item);}} return (A)this;
  }
  public A removeAllFromSources(Collection<String> items) {
    for (String item : items) {if (this.sources!= null){ this.sources.remove(item);}} return (A)this;
  }
  public Boolean hasSources() {
    return sources != null && !sources.isEmpty();
  }
  public Boolean getCreateTarFile() {
    return this.createTarFile;
  }
  public A withCreateTarFile(Boolean createTarFile) {
    this.createTarFile=createTarFile; return (A) this;
  }
  public Boolean hasCreateTarFile() {
    return this.createTarFile != null;
  }
  public String getExtension() {
    return this.extension;
  }
  public A withExtension(String extension) {
    this.extension=extension; return (A) this;
  }
  public Boolean hasExtension() {
    return this.extension != null;
  }
  public String getNotes() {
    return this.notes;
  }
  public A withNotes(String notes) {
    this.notes=notes; return (A) this;
  }
  public Boolean hasNotes() {
    return this.notes != null;
  }
  public String getInputFolder() {
    return this.inputFolder;
  }
  public A withInputFolder(String inputFolder) {
    this.inputFolder=inputFolder; return (A) this;
  }
  public Boolean hasInputFolder() {
    return this.inputFolder != null;
  }
  public String getOutputFolder() {
    return this.outputFolder;
  }
  public A withOutputFolder(String outputFolder) {
    this.outputFolder=outputFolder; return (A) this;
  }
  public Boolean hasOutputFolder() {
    return this.outputFolder != null;
  }
  public A withMaintainers(io.dekorate.helm.config.Maintainer... maintainers) {
    if (this.maintainers != null) {this.maintainers.clear();}
    if (maintainers != null) {for (Maintainer item :maintainers){ this.addToMaintainers(item);}} return (A) this;
  }
  
  /**
   * This method has been deprecated, please use method buildMaintainers instead.
   */
  @Deprecated
  public Maintainer[] getMaintainers() {
    int size = maintainers != null ? maintainers.size() : 0;
Maintainer[] result = new Maintainer[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends Maintainer,?> builder : maintainers) {
    result[index++]=builder.build();
}
return result;

  }
  public Maintainer[] buildMaintainers() {
    int size = maintainers != null ? maintainers.size() : 0;
Maintainer[] result = new Maintainer[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends Maintainer,?> builder : maintainers) {
    result[index++]=builder.build();
}
return result;

  }
  public Maintainer buildMaintainer(Integer index) {
    return this.maintainers.get(index).build();
  }
  public Maintainer buildFirstMaintainer() {
    return this.maintainers.get(0).build();
  }
  public Maintainer buildLastMaintainer() {
    return this.maintainers.get(maintainers.size() - 1).build();
  }
  public Maintainer buildMatchingMaintainer(Predicate<MaintainerBuilder> predicate) {
    for (MaintainerBuilder item: maintainers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingMaintainer(Predicate<MaintainerBuilder> predicate) {
    for (MaintainerBuilder item: maintainers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A addToMaintainers(Integer index,Maintainer item) {
    if (this.maintainers == null) {this.maintainers = new ArrayList<MaintainerBuilder>();}
    MaintainerBuilder builder = new MaintainerBuilder(item);_visitables.get("maintainers").add(index >= 0 ? index : _visitables.get("maintainers").size(), builder);this.maintainers.add(index >= 0 ? index : maintainers.size(), builder); return (A)this;
  }
  public A setToMaintainers(Integer index,Maintainer item) {
    if (this.maintainers == null) {this.maintainers = new ArrayList<MaintainerBuilder>();}
    MaintainerBuilder builder = new MaintainerBuilder(item);
    if (index < 0 || index >= _visitables.get("maintainers").size()) { _visitables.get("maintainers").add(builder); } else { _visitables.get("maintainers").set(index, builder);}
    if (index < 0 || index >= maintainers.size()) { maintainers.add(builder); } else { maintainers.set(index, builder);}
     return (A)this;
  }
  public A addToMaintainers(io.dekorate.helm.config.Maintainer... items) {
    if (this.maintainers == null) {this.maintainers = new ArrayList<MaintainerBuilder>();}
    for (Maintainer item : items) {MaintainerBuilder builder = new MaintainerBuilder(item);_visitables.get("maintainers").add(builder);this.maintainers.add(builder);} return (A)this;
  }
  public A addAllToMaintainers(Collection<Maintainer> items) {
    if (this.maintainers == null) {this.maintainers = new ArrayList<MaintainerBuilder>();}
    for (Maintainer item : items) {MaintainerBuilder builder = new MaintainerBuilder(item);_visitables.get("maintainers").add(builder);this.maintainers.add(builder);} return (A)this;
  }
  public A removeFromMaintainers(io.dekorate.helm.config.Maintainer... items) {
    for (Maintainer item : items) {MaintainerBuilder builder = new MaintainerBuilder(item);_visitables.get("maintainers").remove(builder);if (this.maintainers != null) {this.maintainers.remove(builder);}} return (A)this;
  }
  public A removeAllFromMaintainers(Collection<Maintainer> items) {
    for (Maintainer item : items) {MaintainerBuilder builder = new MaintainerBuilder(item);_visitables.get("maintainers").remove(builder);if (this.maintainers != null) {this.maintainers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromMaintainers(Predicate<MaintainerBuilder> predicate) {
    if (maintainers == null) return (A) this;
    final Iterator<MaintainerBuilder> each = maintainers.iterator();
    final List visitables = _visitables.get("maintainers");
    while (each.hasNext()) {
      MaintainerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public Boolean hasMaintainers() {
    return maintainers != null && !maintainers.isEmpty();
  }
  public A addNewMaintainer(String name,String email,String url) {
    return (A)addToMaintainers(new Maintainer(name, email, url));
  }
  public HelmChartConfigFluent.MaintainersNested<A> addNewMaintainer() {
    return new HelmChartConfigFluentImpl.MaintainersNestedImpl();
  }
  public HelmChartConfigFluent.MaintainersNested<A> addNewMaintainerLike(Maintainer item) {
    return new HelmChartConfigFluentImpl.MaintainersNestedImpl(-1, item);
  }
  public HelmChartConfigFluent.MaintainersNested<A> setNewMaintainerLike(Integer index,Maintainer item) {
    return new HelmChartConfigFluentImpl.MaintainersNestedImpl(index, item);
  }
  public HelmChartConfigFluent.MaintainersNested<A> editMaintainer(Integer index) {
    if (maintainers.size() <= index) throw new RuntimeException("Can't edit maintainers. Index exceeds size.");
    return setNewMaintainerLike(index, buildMaintainer(index));
  }
  public HelmChartConfigFluent.MaintainersNested<A> editFirstMaintainer() {
    if (maintainers.size() == 0) throw new RuntimeException("Can't edit first maintainers. The list is empty.");
    return setNewMaintainerLike(0, buildMaintainer(0));
  }
  public HelmChartConfigFluent.MaintainersNested<A> editLastMaintainer() {
    int index = maintainers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last maintainers. The list is empty.");
    return setNewMaintainerLike(index, buildMaintainer(index));
  }
  public HelmChartConfigFluent.MaintainersNested<A> editMatchingMaintainer(Predicate<MaintainerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<maintainers.size();i++) { 
    if (predicate.test(maintainers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching maintainers. No match found.");
    return setNewMaintainerLike(index, buildMaintainer(index));
  }
  public A withDependencies(io.dekorate.helm.config.HelmDependency... dependencies) {
    if (this.dependencies != null) {this.dependencies.clear();}
    if (dependencies != null) {for (HelmDependency item :dependencies){ this.addToDependencies(item);}} return (A) this;
  }
  
  /**
   * This method has been deprecated, please use method buildDependencies instead.
   */
  @Deprecated
  public HelmDependency[] getDependencies() {
    int size = dependencies != null ? dependencies.size() : 0;
HelmDependency[] result = new HelmDependency[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends HelmDependency,?> builder : dependencies) {
    result[index++]=builder.build();
}
return result;

  }
  public HelmDependency[] buildDependencies() {
    int size = dependencies != null ? dependencies.size() : 0;
HelmDependency[] result = new HelmDependency[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends HelmDependency,?> builder : dependencies) {
    result[index++]=builder.build();
}
return result;

  }
  public HelmDependency buildDependency(Integer index) {
    return this.dependencies.get(index).build();
  }
  public HelmDependency buildFirstDependency() {
    return this.dependencies.get(0).build();
  }
  public HelmDependency buildLastDependency() {
    return this.dependencies.get(dependencies.size() - 1).build();
  }
  public HelmDependency buildMatchingDependency(Predicate<HelmDependencyBuilder> predicate) {
    for (HelmDependencyBuilder item: dependencies) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingDependency(Predicate<HelmDependencyBuilder> predicate) {
    for (HelmDependencyBuilder item: dependencies) { if(predicate.test(item)){ return true;} } return false;
  }
  public A addToDependencies(Integer index,HelmDependency item) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<HelmDependencyBuilder>();}
    HelmDependencyBuilder builder = new HelmDependencyBuilder(item);_visitables.get("dependencies").add(index >= 0 ? index : _visitables.get("dependencies").size(), builder);this.dependencies.add(index >= 0 ? index : dependencies.size(), builder); return (A)this;
  }
  public A setToDependencies(Integer index,HelmDependency item) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<HelmDependencyBuilder>();}
    HelmDependencyBuilder builder = new HelmDependencyBuilder(item);
    if (index < 0 || index >= _visitables.get("dependencies").size()) { _visitables.get("dependencies").add(builder); } else { _visitables.get("dependencies").set(index, builder);}
    if (index < 0 || index >= dependencies.size()) { dependencies.add(builder); } else { dependencies.set(index, builder);}
     return (A)this;
  }
  public A addToDependencies(io.dekorate.helm.config.HelmDependency... items) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<HelmDependencyBuilder>();}
    for (HelmDependency item : items) {HelmDependencyBuilder builder = new HelmDependencyBuilder(item);_visitables.get("dependencies").add(builder);this.dependencies.add(builder);} return (A)this;
  }
  public A addAllToDependencies(Collection<HelmDependency> items) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<HelmDependencyBuilder>();}
    for (HelmDependency item : items) {HelmDependencyBuilder builder = new HelmDependencyBuilder(item);_visitables.get("dependencies").add(builder);this.dependencies.add(builder);} return (A)this;
  }
  public A removeFromDependencies(io.dekorate.helm.config.HelmDependency... items) {
    for (HelmDependency item : items) {HelmDependencyBuilder builder = new HelmDependencyBuilder(item);_visitables.get("dependencies").remove(builder);if (this.dependencies != null) {this.dependencies.remove(builder);}} return (A)this;
  }
  public A removeAllFromDependencies(Collection<HelmDependency> items) {
    for (HelmDependency item : items) {HelmDependencyBuilder builder = new HelmDependencyBuilder(item);_visitables.get("dependencies").remove(builder);if (this.dependencies != null) {this.dependencies.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromDependencies(Predicate<HelmDependencyBuilder> predicate) {
    if (dependencies == null) return (A) this;
    final Iterator<HelmDependencyBuilder> each = dependencies.iterator();
    final List visitables = _visitables.get("dependencies");
    while (each.hasNext()) {
      HelmDependencyBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public Boolean hasDependencies() {
    return dependencies != null && !dependencies.isEmpty();
  }
  public HelmChartConfigFluent.DependenciesNested<A> addNewDependency() {
    return new HelmChartConfigFluentImpl.DependenciesNestedImpl();
  }
  public HelmChartConfigFluent.DependenciesNested<A> addNewDependencyLike(HelmDependency item) {
    return new HelmChartConfigFluentImpl.DependenciesNestedImpl(-1, item);
  }
  public HelmChartConfigFluent.DependenciesNested<A> setNewDependencyLike(Integer index,HelmDependency item) {
    return new HelmChartConfigFluentImpl.DependenciesNestedImpl(index, item);
  }
  public HelmChartConfigFluent.DependenciesNested<A> editDependency(Integer index) {
    if (dependencies.size() <= index) throw new RuntimeException("Can't edit dependencies. Index exceeds size.");
    return setNewDependencyLike(index, buildDependency(index));
  }
  public HelmChartConfigFluent.DependenciesNested<A> editFirstDependency() {
    if (dependencies.size() == 0) throw new RuntimeException("Can't edit first dependencies. The list is empty.");
    return setNewDependencyLike(0, buildDependency(0));
  }
  public HelmChartConfigFluent.DependenciesNested<A> editLastDependency() {
    int index = dependencies.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last dependencies. The list is empty.");
    return setNewDependencyLike(index, buildDependency(index));
  }
  public HelmChartConfigFluent.DependenciesNested<A> editMatchingDependency(Predicate<HelmDependencyBuilder> predicate) {
    int index = -1;
    for (int i=0;i<dependencies.size();i++) { 
    if (predicate.test(dependencies.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching dependencies. No match found.");
    return setNewDependencyLike(index, buildDependency(index));
  }
  public A withValues(io.dekorate.helm.config.ValueReference... values) {
    if (this.values != null) {this.values.clear();}
    if (values != null) {for (ValueReference item :values){ this.addToValues(item);}} return (A) this;
  }
  
  /**
   * This method has been deprecated, please use method buildValues instead.
   */
  @Deprecated
  public ValueReference[] getValues() {
    int size = values != null ? values.size() : 0;
ValueReference[] result = new ValueReference[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends ValueReference,?> builder : values) {
    result[index++]=builder.build();
}
return result;

  }
  public ValueReference[] buildValues() {
    int size = values != null ? values.size() : 0;
ValueReference[] result = new ValueReference[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends ValueReference,?> builder : values) {
    result[index++]=builder.build();
}
return result;

  }
  public ValueReference buildValue(Integer index) {
    return this.values.get(index).build();
  }
  public ValueReference buildFirstValue() {
    return this.values.get(0).build();
  }
  public ValueReference buildLastValue() {
    return this.values.get(values.size() - 1).build();
  }
  public ValueReference buildMatchingValue(Predicate<ValueReferenceBuilder> predicate) {
    for (ValueReferenceBuilder item: values) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingValue(Predicate<ValueReferenceBuilder> predicate) {
    for (ValueReferenceBuilder item: values) { if(predicate.test(item)){ return true;} } return false;
  }
  public A addToValues(Integer index,ValueReference item) {
    if (this.values == null) {this.values = new ArrayList<ValueReferenceBuilder>();}
    ValueReferenceBuilder builder = new ValueReferenceBuilder(item);_visitables.get("values").add(index >= 0 ? index : _visitables.get("values").size(), builder);this.values.add(index >= 0 ? index : values.size(), builder); return (A)this;
  }
  public A setToValues(Integer index,ValueReference item) {
    if (this.values == null) {this.values = new ArrayList<ValueReferenceBuilder>();}
    ValueReferenceBuilder builder = new ValueReferenceBuilder(item);
    if (index < 0 || index >= _visitables.get("values").size()) { _visitables.get("values").add(builder); } else { _visitables.get("values").set(index, builder);}
    if (index < 0 || index >= values.size()) { values.add(builder); } else { values.set(index, builder);}
     return (A)this;
  }
  public A addToValues(io.dekorate.helm.config.ValueReference... items) {
    if (this.values == null) {this.values = new ArrayList<ValueReferenceBuilder>();}
    for (ValueReference item : items) {ValueReferenceBuilder builder = new ValueReferenceBuilder(item);_visitables.get("values").add(builder);this.values.add(builder);} return (A)this;
  }
  public A addAllToValues(Collection<ValueReference> items) {
    if (this.values == null) {this.values = new ArrayList<ValueReferenceBuilder>();}
    for (ValueReference item : items) {ValueReferenceBuilder builder = new ValueReferenceBuilder(item);_visitables.get("values").add(builder);this.values.add(builder);} return (A)this;
  }
  public A removeFromValues(io.dekorate.helm.config.ValueReference... items) {
    for (ValueReference item : items) {ValueReferenceBuilder builder = new ValueReferenceBuilder(item);_visitables.get("values").remove(builder);if (this.values != null) {this.values.remove(builder);}} return (A)this;
  }
  public A removeAllFromValues(Collection<ValueReference> items) {
    for (ValueReference item : items) {ValueReferenceBuilder builder = new ValueReferenceBuilder(item);_visitables.get("values").remove(builder);if (this.values != null) {this.values.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromValues(Predicate<ValueReferenceBuilder> predicate) {
    if (values == null) return (A) this;
    final Iterator<ValueReferenceBuilder> each = values.iterator();
    final List visitables = _visitables.get("values");
    while (each.hasNext()) {
      ValueReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public Boolean hasValues() {
    return values != null && !values.isEmpty();
  }
  public A addNewValue(String property,String[] paths,String profile,String value,String expression) {
    return (A)addToValues(new ValueReference(property, paths, profile, value, expression));
  }
  public HelmChartConfigFluent.ValuesNested<A> addNewValue() {
    return new HelmChartConfigFluentImpl.ValuesNestedImpl();
  }
  public HelmChartConfigFluent.ValuesNested<A> addNewValueLike(ValueReference item) {
    return new HelmChartConfigFluentImpl.ValuesNestedImpl(-1, item);
  }
  public HelmChartConfigFluent.ValuesNested<A> setNewValueLike(Integer index,ValueReference item) {
    return new HelmChartConfigFluentImpl.ValuesNestedImpl(index, item);
  }
  public HelmChartConfigFluent.ValuesNested<A> editValue(Integer index) {
    if (values.size() <= index) throw new RuntimeException("Can't edit values. Index exceeds size.");
    return setNewValueLike(index, buildValue(index));
  }
  public HelmChartConfigFluent.ValuesNested<A> editFirstValue() {
    if (values.size() == 0) throw new RuntimeException("Can't edit first values. The list is empty.");
    return setNewValueLike(0, buildValue(0));
  }
  public HelmChartConfigFluent.ValuesNested<A> editLastValue() {
    int index = values.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last values. The list is empty.");
    return setNewValueLike(index, buildValue(index));
  }
  public HelmChartConfigFluent.ValuesNested<A> editMatchingValue(Predicate<ValueReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<values.size();i++) { 
    if (predicate.test(values.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching values. No match found.");
    return setNewValueLike(index, buildValue(index));
  }
  public A withExpressions(io.dekorate.helm.config.HelmExpression... expressions) {
    if (this.expressions != null) {this.expressions.clear();}
    if (expressions != null) {for (HelmExpression item :expressions){ this.addToExpressions(item);}} return (A) this;
  }
  
  /**
   * This method has been deprecated, please use method buildExpressions instead.
   */
  @Deprecated
  public HelmExpression[] getExpressions() {
    int size = expressions != null ? expressions.size() : 0;
HelmExpression[] result = new HelmExpression[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends HelmExpression,?> builder : expressions) {
    result[index++]=builder.build();
}
return result;

  }
  public HelmExpression[] buildExpressions() {
    int size = expressions != null ? expressions.size() : 0;
HelmExpression[] result = new HelmExpression[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends HelmExpression,?> builder : expressions) {
    result[index++]=builder.build();
}
return result;

  }
  public HelmExpression buildExpression(Integer index) {
    return this.expressions.get(index).build();
  }
  public HelmExpression buildFirstExpression() {
    return this.expressions.get(0).build();
  }
  public HelmExpression buildLastExpression() {
    return this.expressions.get(expressions.size() - 1).build();
  }
  public HelmExpression buildMatchingExpression(Predicate<HelmExpressionBuilder> predicate) {
    for (HelmExpressionBuilder item: expressions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingExpression(Predicate<HelmExpressionBuilder> predicate) {
    for (HelmExpressionBuilder item: expressions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A addToExpressions(Integer index,HelmExpression item) {
    if (this.expressions == null) {this.expressions = new ArrayList<HelmExpressionBuilder>();}
    HelmExpressionBuilder builder = new HelmExpressionBuilder(item);_visitables.get("expressions").add(index >= 0 ? index : _visitables.get("expressions").size(), builder);this.expressions.add(index >= 0 ? index : expressions.size(), builder); return (A)this;
  }
  public A setToExpressions(Integer index,HelmExpression item) {
    if (this.expressions == null) {this.expressions = new ArrayList<HelmExpressionBuilder>();}
    HelmExpressionBuilder builder = new HelmExpressionBuilder(item);
    if (index < 0 || index >= _visitables.get("expressions").size()) { _visitables.get("expressions").add(builder); } else { _visitables.get("expressions").set(index, builder);}
    if (index < 0 || index >= expressions.size()) { expressions.add(builder); } else { expressions.set(index, builder);}
     return (A)this;
  }
  public A addToExpressions(io.dekorate.helm.config.HelmExpression... items) {
    if (this.expressions == null) {this.expressions = new ArrayList<HelmExpressionBuilder>();}
    for (HelmExpression item : items) {HelmExpressionBuilder builder = new HelmExpressionBuilder(item);_visitables.get("expressions").add(builder);this.expressions.add(builder);} return (A)this;
  }
  public A addAllToExpressions(Collection<HelmExpression> items) {
    if (this.expressions == null) {this.expressions = new ArrayList<HelmExpressionBuilder>();}
    for (HelmExpression item : items) {HelmExpressionBuilder builder = new HelmExpressionBuilder(item);_visitables.get("expressions").add(builder);this.expressions.add(builder);} return (A)this;
  }
  public A removeFromExpressions(io.dekorate.helm.config.HelmExpression... items) {
    for (HelmExpression item : items) {HelmExpressionBuilder builder = new HelmExpressionBuilder(item);_visitables.get("expressions").remove(builder);if (this.expressions != null) {this.expressions.remove(builder);}} return (A)this;
  }
  public A removeAllFromExpressions(Collection<HelmExpression> items) {
    for (HelmExpression item : items) {HelmExpressionBuilder builder = new HelmExpressionBuilder(item);_visitables.get("expressions").remove(builder);if (this.expressions != null) {this.expressions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromExpressions(Predicate<HelmExpressionBuilder> predicate) {
    if (expressions == null) return (A) this;
    final Iterator<HelmExpressionBuilder> each = expressions.iterator();
    final List visitables = _visitables.get("expressions");
    while (each.hasNext()) {
      HelmExpressionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public Boolean hasExpressions() {
    return expressions != null && !expressions.isEmpty();
  }
  public A addNewExpression(String path,String expression) {
    return (A)addToExpressions(new HelmExpression(path, expression));
  }
  public HelmChartConfigFluent.ExpressionsNested<A> addNewExpression() {
    return new HelmChartConfigFluentImpl.ExpressionsNestedImpl();
  }
  public HelmChartConfigFluent.ExpressionsNested<A> addNewExpressionLike(HelmExpression item) {
    return new HelmChartConfigFluentImpl.ExpressionsNestedImpl(-1, item);
  }
  public HelmChartConfigFluent.ExpressionsNested<A> setNewExpressionLike(Integer index,HelmExpression item) {
    return new HelmChartConfigFluentImpl.ExpressionsNestedImpl(index, item);
  }
  public HelmChartConfigFluent.ExpressionsNested<A> editExpression(Integer index) {
    if (expressions.size() <= index) throw new RuntimeException("Can't edit expressions. Index exceeds size.");
    return setNewExpressionLike(index, buildExpression(index));
  }
  public HelmChartConfigFluent.ExpressionsNested<A> editFirstExpression() {
    if (expressions.size() == 0) throw new RuntimeException("Can't edit first expressions. The list is empty.");
    return setNewExpressionLike(0, buildExpression(0));
  }
  public HelmChartConfigFluent.ExpressionsNested<A> editLastExpression() {
    int index = expressions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last expressions. The list is empty.");
    return setNewExpressionLike(index, buildExpression(index));
  }
  public HelmChartConfigFluent.ExpressionsNested<A> editMatchingExpression(Predicate<HelmExpressionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<expressions.size();i++) { 
    if (predicate.test(expressions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching expressions. No match found.");
    return setNewExpressionLike(index, buildExpression(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HelmChartConfigFluentImpl that = (HelmChartConfigFluentImpl) o;
    if (enabled != null ? !enabled.equals(that.enabled) :that.enabled != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (valuesRootAlias != null ? !valuesRootAlias.equals(that.valuesRootAlias) :that.valuesRootAlias != null) return false;
    if (description != null ? !description.equals(that.description) :that.description != null) return false;
    if (version != null ? !version.equals(that.version) :that.version != null) return false;
    if (icon != null ? !icon.equals(that.icon) :that.icon != null) return false;
    if (home != null ? !home.equals(that.home) :that.home != null) return false;
    if (keywords != null ? !keywords.equals(that.keywords) :that.keywords != null) return false;
    if (sources != null ? !sources.equals(that.sources) :that.sources != null) return false;
    if (createTarFile != null ? !createTarFile.equals(that.createTarFile) :that.createTarFile != null) return false;
    if (extension != null ? !extension.equals(that.extension) :that.extension != null) return false;
    if (notes != null ? !notes.equals(that.notes) :that.notes != null) return false;
    if (inputFolder != null ? !inputFolder.equals(that.inputFolder) :that.inputFolder != null) return false;
    if (outputFolder != null ? !outputFolder.equals(that.outputFolder) :that.outputFolder != null) return false;
    if (maintainers != null ? !maintainers.equals(that.maintainers) :that.maintainers != null) return false;
    if (dependencies != null ? !dependencies.equals(that.dependencies) :that.dependencies != null) return false;
    if (values != null ? !values.equals(that.values) :that.values != null) return false;
    if (expressions != null ? !expressions.equals(that.expressions) :that.expressions != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(enabled,  name,  apiVersion,  valuesRootAlias,  description,  version,  icon,  home,  keywords,  sources,  createTarFile,  extension,  notes,  inputFolder,  outputFolder,  maintainers,  dependencies,  values,  expressions,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (enabled != null) { sb.append("enabled:"); sb.append(enabled + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (valuesRootAlias != null) { sb.append("valuesRootAlias:"); sb.append(valuesRootAlias + ","); }
    if (description != null) { sb.append("description:"); sb.append(description + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (icon != null) { sb.append("icon:"); sb.append(icon + ","); }
    if (home != null) { sb.append("home:"); sb.append(home + ","); }
    if (keywords != null && !keywords.isEmpty()) { sb.append("keywords:"); sb.append(keywords + ","); }
    if (sources != null && !sources.isEmpty()) { sb.append("sources:"); sb.append(sources + ","); }
    if (createTarFile != null) { sb.append("createTarFile:"); sb.append(createTarFile + ","); }
    if (extension != null) { sb.append("extension:"); sb.append(extension + ","); }
    if (notes != null) { sb.append("notes:"); sb.append(notes + ","); }
    if (inputFolder != null) { sb.append("inputFolder:"); sb.append(inputFolder + ","); }
    if (outputFolder != null) { sb.append("outputFolder:"); sb.append(outputFolder + ","); }
    if (maintainers != null && !maintainers.isEmpty()) { sb.append("maintainers:"); sb.append(maintainers + ","); }
    if (dependencies != null && !dependencies.isEmpty()) { sb.append("dependencies:"); sb.append(dependencies + ","); }
    if (values != null && !values.isEmpty()) { sb.append("values:"); sb.append(values + ","); }
    if (expressions != null && !expressions.isEmpty()) { sb.append("expressions:"); sb.append(expressions); }
    sb.append("}");
    return sb.toString();
  }
  public A withEnabled() {
    return withEnabled(true);
  }
  public A withCreateTarFile() {
    return withCreateTarFile(true);
  }
  class MaintainersNestedImpl<N> extends MaintainerFluentImpl<HelmChartConfigFluent.MaintainersNested<N>> implements HelmChartConfigFluent.MaintainersNested<N>,Nested<N>{
    MaintainersNestedImpl(Integer index,Maintainer item) {
      this.index = index;
      this.builder = new MaintainerBuilder(this, item);
    }
    MaintainersNestedImpl() {
      this.index = -1;
      this.builder = new MaintainerBuilder(this);
    }
    MaintainerBuilder builder;
    Integer index;
    public N and() {
      return (N) HelmChartConfigFluentImpl.this.setToMaintainers(index,builder.build());
    }
    public N endMaintainer() {
      return and();
    }
    
  }
  class DependenciesNestedImpl<N> extends HelmDependencyFluentImpl<HelmChartConfigFluent.DependenciesNested<N>> implements HelmChartConfigFluent.DependenciesNested<N>,Nested<N>{
    DependenciesNestedImpl(Integer index,HelmDependency item) {
      this.index = index;
      this.builder = new HelmDependencyBuilder(this, item);
    }
    DependenciesNestedImpl() {
      this.index = -1;
      this.builder = new HelmDependencyBuilder(this);
    }
    HelmDependencyBuilder builder;
    Integer index;
    public N and() {
      return (N) HelmChartConfigFluentImpl.this.setToDependencies(index,builder.build());
    }
    public N endDependency() {
      return and();
    }
    
  }
  class ValuesNestedImpl<N> extends ValueReferenceFluentImpl<HelmChartConfigFluent.ValuesNested<N>> implements HelmChartConfigFluent.ValuesNested<N>,Nested<N>{
    ValuesNestedImpl(Integer index,ValueReference item) {
      this.index = index;
      this.builder = new ValueReferenceBuilder(this, item);
    }
    ValuesNestedImpl() {
      this.index = -1;
      this.builder = new ValueReferenceBuilder(this);
    }
    ValueReferenceBuilder builder;
    Integer index;
    public N and() {
      return (N) HelmChartConfigFluentImpl.this.setToValues(index,builder.build());
    }
    public N endValue() {
      return and();
    }
    
  }
  class ExpressionsNestedImpl<N> extends HelmExpressionFluentImpl<HelmChartConfigFluent.ExpressionsNested<N>> implements HelmChartConfigFluent.ExpressionsNested<N>,Nested<N>{
    ExpressionsNestedImpl(Integer index,HelmExpression item) {
      this.index = index;
      this.builder = new HelmExpressionBuilder(this, item);
    }
    ExpressionsNestedImpl() {
      this.index = -1;
      this.builder = new HelmExpressionBuilder(this);
    }
    HelmExpressionBuilder builder;
    Integer index;
    public N and() {
      return (N) HelmChartConfigFluentImpl.this.setToExpressions(index,builder.build());
    }
    public N endExpression() {
      return and();
    }
    
  }
  
}