package io.dekorate.helm.adapter;

import java.util.stream.Collectors;
import io.dekorate.helm.config.HelmExpression;
import io.dekorate.helm.config.HelmChartConfigBuilder;
import java.lang.String;
import io.dekorate.helm.config.HelmDependency;
import io.dekorate.helm.config.Maintainer;
import io.dekorate.project.Project;
import io.dekorate.project.BuildInfo;
import io.dekorate.helm.annotation.HelmChart;
import java.lang.Object;
import java.util.List;
import io.dekorate.project.ScmInfo;
import java.lang.Boolean;
import java.util.Arrays;
import java.util.Map;
import io.dekorate.helm.config.HelmChartConfig;
import io.dekorate.helm.config.ValueReference;

 /**
  * Generated
  */
public class HelmChartConfigAdapter{
  public static HelmChartConfig adapt(HelmChart instance) {
    return newBuilder(instance).build();
  }
  public static HelmChartConfigBuilder newBuilder(HelmChart instance) {
    return new HelmChartConfigBuilder(new HelmChartConfig(null,
            null,
            instance.enabled(),
            instance.name(),
            instance.apiVersion(),
            instance.valuesRootAlias(),
            instance.description(),
            instance.version(),
            instance.icon(),
            instance.home(),
            instance.keywords(),
            instance.sources(),
            instance.createTarFile(),
            instance.extension(),
            instance.notes(),
            instance.inputFolder(),
            instance.outputFolder(),
            Arrays.asList(instance.maintainers()).stream().map(i ->new Maintainer(i.name(),
            i.email(),
            i.url())).collect(Collectors.toList()).toArray(new Maintainer[0]),
            Arrays.asList(instance.dependencies()).stream().map(i ->new HelmDependency(i.name(),
            i.alias(),
            i.version(),
            i.repository(),
            i.condition(),
            i.tags())).collect(Collectors.toList()).toArray(new HelmDependency[0]),
            Arrays.asList(instance.values()).stream().map(i ->new ValueReference(i.property(),
            i.paths(),
            i.profile(),
            i.value(),
            i.expression())).collect(Collectors.toList()).toArray(new ValueReference[0]),
            Arrays.asList(instance.expressions()).stream().map(i ->new HelmExpression(i.path(),
            i.expression())).collect(Collectors.toList()).toArray(new HelmExpression[0])));
  }
  public static HelmChartConfig adapt(Map map) {
    return new HelmChartConfig(
null,
null,
               (Boolean)(map instanceof Map ? ((Map)map).getOrDefault("enabled", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("name", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("apiVersion", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("valuesRootAlias", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("description", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("version", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("icon", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("home", null) : null),
map instanceof Map ? toStringArray(((Map)map).get("keywords")) : toStringArray(map),
map instanceof Map ? toStringArray(((Map)map).get("sources")) : toStringArray(map),
               (Boolean)(map instanceof Map ? ((Map)map).getOrDefault("createTarFile", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("extension", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("notes", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("inputFolder", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("outputFolder", null) : null),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("maintainers" , new Map[0]) : new Map[0])).map(i ->new Maintainer(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("email", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("url", null) : null))).toArray(size-> new Maintainer[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("dependencies" , new Map[0]) : new Map[0])).map(i ->new HelmDependency(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("alias", "") : ""),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("version", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("repository", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("condition", "") : ""),
i instanceof Map ? toStringArray(((Map)i).get("tags")) : toStringArray(i))).toArray(size-> new HelmDependency[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("values" , new Map[0]) : new Map[0])).map(i ->new ValueReference(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("property", null) : null),
i instanceof Map ? toStringArray(((Map)i).get("paths")) : toStringArray(i),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("profile", "") : ""),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("value", "") : ""),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("expression", "") : ""))).toArray(size-> new ValueReference[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("expressions" , new Map[0]) : new Map[0])).map(i ->new HelmExpression(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("path", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("expression", null) : null))).toArray(size-> new HelmExpression[size]));
  }
  public static HelmChartConfigBuilder newBuilder(Map map) {
    return new HelmChartConfigBuilder(new HelmChartConfig(
null,
null,
               (Boolean)(map instanceof Map ? ((Map)map).getOrDefault("enabled", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("name", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("apiVersion", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("valuesRootAlias", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("description", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("version", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("icon", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("home", null) : null),
map instanceof Map ? toStringArray(((Map)map).get("keywords")) : toStringArray(map),
map instanceof Map ? toStringArray(((Map)map).get("sources")) : toStringArray(map),
               (Boolean)(map instanceof Map ? ((Map)map).getOrDefault("createTarFile", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("extension", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("notes", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("inputFolder", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("outputFolder", null) : null),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("maintainers" , new Map[0]) : new Map[0])).map(i ->new Maintainer(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("email", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("url", null) : null))).toArray(size-> new Maintainer[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("dependencies" , new Map[0]) : new Map[0])).map(i ->new HelmDependency(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("alias", "") : ""),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("version", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("repository", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("condition", "") : ""),
i instanceof Map ? toStringArray(((Map)i).get("tags")) : toStringArray(i))).toArray(size-> new HelmDependency[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("values" , new Map[0]) : new Map[0])).map(i ->new ValueReference(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("property", null) : null),
i instanceof Map ? toStringArray(((Map)i).get("paths")) : toStringArray(i),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("profile", "") : ""),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("value", "") : ""),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("expression", "") : ""))).toArray(size-> new ValueReference[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("expressions" , new Map[0]) : new Map[0])).map(i ->new HelmExpression(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("path", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("expression", null) : null))).toArray(size-> new HelmExpression[size])));
  }
  public static String[] toStringArray(Object o) {
            if (o instanceof String[]) {
          return (String[]) o;
        }
        if (o instanceof String) {
          String s =  (String) o;
          return s.split(",[ ]*");
        }
        else if (o instanceof List) {
          List c = (List) o;
          String[] result = new String[c.size()]; 
          for (int i=0; i <= c.size(); i++) {
            result[i] = String.valueOf(c.get(i));
          }
          return result;
        }
        return new String[0];
    

  }
  
}