/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.helm.listener;

import com.fasterxml.jackson.core.type.TypeReference;
import io.dekorate.ConfigReference;
import io.dekorate.Logger;
import io.dekorate.LoggerFactory;
import io.dekorate.Session;
import io.dekorate.SessionListener;
import io.dekorate.WithConfigReferences;
import io.dekorate.WithProject;
import io.dekorate.WithSession;
import io.dekorate.helm.config.HelmChartConfig;
import io.dekorate.helm.config.HelmExpression;
import io.dekorate.helm.config.ValueReference;
import io.dekorate.helm.model.Chart;
import io.dekorate.helm.model.HelmDependency;
import io.dekorate.helm.model.Maintainer;
import io.dekorate.helm.util.HelmTarArchiver;
import io.dekorate.project.Project;
import io.dekorate.utils.Exec;
import io.dekorate.utils.Maps;
import io.dekorate.utils.Serialization;
import io.dekorate.utils.Strings;
import io.github.yamlpath.YamlExpressionParser;
import io.github.yamlpath.YamlPath;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HelmWriterSessionListener
implements SessionListener,
WithProject,
WithSession {
    private static final String YAML = ".yaml";
    private static final String YAML_REG_EXP = ".*?\\.ya?ml$";
    private static final String CHART_FILENAME = "Chart.yaml";
    private static final String VALUES = "values";
    private static final String TEMPLATES = "templates";
    private static final String CHARTS = "charts";
    private static final String NOTES = "NOTES.txt";
    private static final String README = "README.md";
    private static final String LICENSE = "LICENSE";
    private static final String VALUES_SCHEMA_JSON = "values.schema.json";
    private static final String KUBERNETES_CLASSIFIER = "helm";
    private static final String OPENSHIFT_CLASSIFIER = "helmshift";
    private static final String OPENSHIFT = "openshift";
    private static final String KIND = "kind";
    private static final String START_TAG = "{{";
    private static final String END_TAG = "}}";
    private static final String VALUES_START_TAG = "{{ .Values.";
    private static final String VALUES_END_TAG = " }}";
    private static final String EMPTY = "";
    private static final String TEMPLATE_FUNCTION_START_TAG = "{{- define";
    private static final String TEMPLATE_FUNCTION_END_TAG = "{{- end }}";
    private static final String HELM_HELPER_PREFIX = "_";
    private static final boolean APPEND = true;
    private static final String SEPARATOR_TOKEN = ":LINE_SEPARATOR:";
    private static final String START_EXPRESSION_TOKEN = "\":START:";
    private static final String END_EXPRESSION_TOKEN = ":END:\"";
    private static final Logger LOGGER = LoggerFactory.getLogger();

    public void onClosed() {
        Session session = this.getSession();
        Project project = this.getProject();
        Path outputDir = project.getBuildInfo().getClassOutputDir().resolve(project.getDekorateOutputDir());
        session.getConfigurationRegistry().get(HelmChartConfig.class).ifPresent(helmConfig -> {
            Path baseDir = this.getProject().getBuildInfo().getResourceDir();
            if (this.getProject().getDekorateInputDir() != null) {
                baseDir = baseDir.resolve(this.getProject().getDekorateInputDir());
            }
            Path inputDir = baseDir.resolve(helmConfig.getInputFolder());
            List<ConfigReference> configReferences = Stream.of(helmConfig.getValues()).map(this::toConfigReference).collect(Collectors.toList());
            this.writeHelmFiles(session, project, (HelmChartConfig)((Object)helmConfig), configReferences, inputDir, outputDir.resolve(helmConfig.getOutputFolder()), (Collection<File>)HelmWriterSessionListener.listYamls(outputDir));
        });
    }

    public Map<String, String> writeHelmFiles(Session session, Project project, HelmChartConfig helmConfig, List<ConfigReference> configReferences, Path inputDir, Path outputDir, Collection<File> generatedFiles) {
        HashMap<String, String> artifacts = new HashMap<String, String>();
        if (helmConfig.isEnabled()) {
            this.validateHelmConfig(helmConfig);
            List<ConfigReference> valuesReferences = this.mergeValuesReferencesFromDecorators(configReferences, session);
            try {
                LOGGER.info(String.format("Creating Helm Chart \"%s\"", helmConfig.getName()));
                HashMap<String, Object> prodValues = new HashMap<String, Object>();
                HashMap<String, Map<String, Object>> valuesByProfile = new HashMap<String, Map<String, Object>>();
                artifacts.putAll(this.processTemplates(helmConfig, inputDir, outputDir, generatedFiles, valuesReferences, prodValues, valuesByProfile));
                artifacts.putAll(this.createChartYaml(helmConfig, project, outputDir));
                artifacts.putAll(this.createValuesYaml(helmConfig, valuesReferences, inputDir, outputDir, prodValues, valuesByProfile));
                artifacts.putAll(this.createEmptyChartFolder(helmConfig, outputDir));
                artifacts.putAll(this.addNotesIntoTemplatesFolder(helmConfig, inputDir, outputDir));
                artifacts.putAll(this.addResourceIfExists(helmConfig, LICENSE, inputDir, outputDir));
                artifacts.putAll(this.addResourceIfExists(helmConfig, README, inputDir, outputDir));
                artifacts.putAll(this.addResourceIfExists(helmConfig, VALUES_SCHEMA_JSON, inputDir, outputDir));
                if (helmConfig.isCreateTarFile()) {
                    this.fetchDependencies(helmConfig, outputDir);
                    artifacts.putAll(this.createTarball(helmConfig, project, outputDir, artifacts));
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error writing resources", e);
            }
        }
        return artifacts;
    }

    private void fetchDependencies(HelmChartConfig helmConfig, Path outputDir) {
        if (helmConfig.getDependencies() != null && helmConfig.getDependencies().length > 0) {
            Path chartFolder = this.getChartOutputDir(helmConfig, outputDir);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            boolean success = Exec.inPath((Path)chartFolder).redirectingOutput((OutputStream)out).commands(new String[]{KUBERNETES_CLASSIFIER, "dependency", "build"});
            if (success) {
                LOGGER.info("Dependencies successfully fetched");
            } else {
                throw new RuntimeException("Error fetching Helm dependencies. Cause: " + new String(out.toByteArray()));
            }
        }
    }

    private void validateHelmConfig(HelmChartConfig helmConfig) {
        if (Strings.isNullOrEmpty((String)helmConfig.getName())) {
            throw new RuntimeException("Helm Chart name is required!");
        }
    }

    private Map<String, String> addResourceIfExists(HelmChartConfig helmConfig, String resourceName, Path inputDir, Path outputDir) throws IOException {
        File file = inputDir.resolve(resourceName).toFile();
        if (!file.exists()) {
            return Collections.emptyMap();
        }
        Path chartOutputDir = this.getChartOutputDir(helmConfig, outputDir).resolve(resourceName);
        Files.copy(new FileInputStream(file), chartOutputDir, new CopyOption[0]);
        return Collections.singletonMap(chartOutputDir.toString(), EMPTY);
    }

    private Map<String, String> addNotesIntoTemplatesFolder(HelmChartConfig helmConfig, Path inputDir, Path outputDir) throws IOException {
        InputStream notesInputStream;
        File notesInInputDir = inputDir.resolve(NOTES).toFile();
        if (notesInInputDir.exists()) {
            notesInputStream = new FileInputStream(notesInInputDir);
        } else {
            if (Strings.isNullOrEmpty((String)helmConfig.getNotes())) {
                return Collections.emptyMap();
            }
            notesInputStream = this.getResourceFromClasspath(helmConfig.getNotes());
        }
        if (notesInputStream == null) {
            throw new RuntimeException("Could not find the notes template file in the classpath at " + helmConfig.getNotes());
        }
        Path chartOutputDir = this.getChartOutputDir(helmConfig, outputDir).resolve(TEMPLATES).resolve(NOTES);
        Files.copy(notesInputStream, chartOutputDir, new CopyOption[0]);
        return Collections.singletonMap(chartOutputDir.toString(), EMPTY);
    }

    private InputStream getResourceFromClasspath(String notes) {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(notes);
        if (is == null) {
            is = HelmWriterSessionListener.class.getResourceAsStream(notes);
        }
        return is;
    }

    private Map<String, String> createEmptyChartFolder(HelmChartConfig helmConfig, Path outputDir) throws IOException {
        Path emptyChartsDir = this.getChartOutputDir(helmConfig, outputDir).resolve(CHARTS);
        Files.createDirectories(emptyChartsDir, new FileAttribute[0]);
        return Collections.singletonMap(emptyChartsDir.toString(), EMPTY);
    }

    private List<ConfigReference> mergeValuesReferencesFromDecorators(List<ConfigReference> configReferencesFromConfig, Session session) {
        LinkedList<ConfigReference> configReferences = new LinkedList<ConfigReference>();
        for (WithConfigReferences decorator : session.getResourceRegistry().getConfigReferences()) {
            configReferences.addAll(decorator.getConfigReferences());
        }
        configReferences.addAll(configReferencesFromConfig);
        return configReferences;
    }

    private boolean valueHasPath(ConfigReference valueReference) {
        return valueReference.getPaths() != null && valueReference.getPaths().length > 0;
    }

    private ConfigReference toConfigReference(ValueReference valueReference) {
        return new ConfigReference(valueReference.getProperty(), valueReference.getPaths(), (Object)(Strings.isNullOrEmpty((String)valueReference.getValue()) ? null : valueReference.getValue()), valueReference.getExpression(), valueReference.getProfile());
    }

    private Map<String, String> createValuesYaml(HelmChartConfig helmConfig, List<ConfigReference> configReferences, Path inputDir, Path outputDir, Map<String, Object> prodValues, Map<String, Map<String, Object>> valuesByProfile) throws IOException {
        for (ConfigReference value : configReferences) {
            if (this.valueHasPath(value)) continue;
            if (value.getValue() == null) {
                throw new RuntimeException("The value mapping for " + value.getProperty() + " does not have either a path or a default value. ");
            }
            String property = value.getProperty();
            if (!this.startWithDependencyPrefix(value.getProperty(), helmConfig.getDependencies())) {
                property = helmConfig.getValuesRootAlias() + "." + value.getProperty();
            }
            prodValues.put(Strings.kebabToCamelCase((String)property), value.getValue());
        }
        HashMap<String, String> artifacts = new HashMap<String, String>();
        for (Map.Entry<String, Map<String, Object>> valuesInProfile : valuesByProfile.entrySet()) {
            String profile = valuesInProfile.getKey();
            Map<String, Object> values = valuesInProfile.getValue();
            for (Map.Entry<String, Object> prodValue : prodValues.entrySet()) {
                if (values.containsKey(prodValue.getKey())) continue;
                values.put(prodValue.getKey(), prodValue.getValue());
            }
            artifacts.putAll(this.writeFileAsYaml(this.mergeValues(inputDir, values), this.getChartOutputDir(helmConfig, outputDir).resolve("values." + profile + YAML)));
        }
        artifacts.putAll(this.writeFileAsYaml(this.mergeValues(inputDir, prodValues), this.getChartOutputDir(helmConfig, outputDir).resolve("values.yaml")));
        return artifacts;
    }

    private Map<String, Object> mergeValues(Path inputDir, Map<String, Object> values) throws FileNotFoundException {
        Map<String, Object> valuesAsMultiValueMap = HelmWriterSessionListener.toMultiValueMap(values);
        File templateValuesFile = inputDir.resolve("values.yaml").toFile();
        if (templateValuesFile.exists()) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            Map yaml = (Map)Serialization.unmarshal((InputStream)new FileInputStream(templateValuesFile), (TypeReference)new TypeReference<Map<String, Object>>(){});
            result.putAll(yaml);
            Maps.merge(result, valuesAsMultiValueMap);
            return result;
        }
        return valuesAsMultiValueMap;
    }

    private boolean startWithDependencyPrefix(String property, io.dekorate.helm.config.HelmDependency[] dependencies) {
        if (dependencies == null || dependencies.length == 0) {
            return false;
        }
        String[] parts = property.split(Pattern.quote("."));
        if (parts.length <= 1) {
            return false;
        }
        String name = parts[0];
        return Stream.of(dependencies).map(d -> Strings.defaultIfEmpty((String)d.getAlias(), (String)d.getName())).anyMatch(d -> Strings.equals((String)d, (String)name));
    }

    private Map<String, String> createTarball(HelmChartConfig helmConfig, Project project, Path outputDir, Map<String, String> artifacts) throws IOException {
        File tarballFile = outputDir.resolve(String.format("%s-%s-%s.%s", helmConfig.getName(), this.getVersion(helmConfig, project), this.getHelmClassifier(artifacts), helmConfig.getExtension())).toFile();
        LOGGER.debug(String.format("Creating Helm configuration Tarball: '%s'", tarballFile));
        Path helmSources = this.getChartOutputDir(helmConfig, outputDir);
        ArrayList<File> files = new ArrayList<File>();
        for (String filePath : artifacts.keySet()) {
            File file = new File(filePath);
            if (file.isDirectory()) {
                files.addAll(Arrays.asList(file.listFiles()));
                continue;
            }
            files.add(file);
        }
        HelmTarArchiver.createTarBall(tarballFile, helmSources.toFile(), files, helmConfig.getExtension(), tae -> tae.setName(String.format("%s/%s", helmConfig.getName(), tae.getName())));
        return Collections.singletonMap(tarballFile.toString(), null);
    }

    private String getVersion(HelmChartConfig helmConfig, Project project) {
        if (Strings.isNullOrEmpty((String)helmConfig.getVersion())) {
            return project.getBuildInfo().getVersion();
        }
        return helmConfig.getVersion();
    }

    private Map<String, String> processTemplates(HelmChartConfig helmConfig, Path inputDir, Path outputDir, Collection<File> generatedFiles, List<ConfigReference> valuesReferences, Map<String, Object> prodValues, Map<String, Map<String, Object>> valuesByProfile) throws IOException {
        HashMap<String, String> templates = new HashMap<String, String>();
        Path templatesDir = this.getChartOutputDir(helmConfig, outputDir).resolve(TEMPLATES);
        Files.createDirectories(templatesDir, new FileAttribute[0]);
        List<Map<Object, Object>> resources = this.replaceValuesInYamls(helmConfig, generatedFiles, valuesReferences, prodValues, valuesByProfile);
        Map<String, String> functionsByResource = this.processUserDefinedTemplates(inputDir, templates, templatesDir);
        for (Map<Object, Object> resource : resources) {
            if (helmConfig.getExpressions() != null) {
                YamlExpressionParser parser = new YamlExpressionParser(Arrays.asList(resource));
                for (HelmExpression expressionConfig : helmConfig.getExpressions()) {
                    if (expressionConfig.getPath() == null || expressionConfig.getExpression() == null) continue;
                    HelmWriterSessionListener.readAndSet(parser, expressionConfig.getPath(), expressionConfig.getExpression());
                }
            }
            String kind = (String)resource.get(KIND);
            Path targetFile = templatesDir.resolve(kind.toLowerCase() + YAML);
            String functions = functionsByResource.get(kind.toLowerCase() + YAML);
            String adaptedString = Serialization.yamlMapper().writeValueAsString(resource);
            if (functions != null) {
                adaptedString = functions + System.lineSeparator() + adaptedString;
            }
            adaptedString = adaptedString.replaceAll(Pattern.quote("\"{{"), START_TAG).replaceAll(Pattern.quote("}}\""), END_TAG).replaceAll(Pattern.quote("\\\""), "\"").replaceAll(SEPARATOR_TOKEN, System.lineSeparator()).replaceAll(Pattern.quote("\"\":START:"), EMPTY).replaceAll(Pattern.quote(":END:\"\""), EMPTY).replaceAll("\\\\\\n(\\s)*\\\\", EMPTY);
            this.writeFile(adaptedString, targetFile);
            templates.put(targetFile.toString(), adaptedString);
        }
        return templates;
    }

    private Map<String, String> processUserDefinedTemplates(Path inputDir, Map<String, String> templates, Path templatesDir) throws IOException {
        HashMap<String, String> functionsByResource = new HashMap<String, String>();
        File inputTemplates = inputDir.resolve(TEMPLATES).toFile();
        if (inputTemplates.exists()) {
            File[] userTemplates;
            for (File userTemplateFile : userTemplates = inputTemplates.listFiles()) {
                if (userTemplateFile.getName().startsWith(HELM_HELPER_PREFIX)) {
                    Path output = templatesDir.resolve(userTemplateFile.getName());
                    Files.copy(new FileInputStream(userTemplateFile), output, new CopyOption[0]);
                    templates.put(output.toString(), EMPTY);
                    continue;
                }
                String[] userResource = Strings.read((InputStream)new FileInputStream(userTemplateFile)).split(System.lineSeparator());
                StringBuilder sb = new StringBuilder();
                boolean isFunction = false;
                for (String lineUserResource : userResource) {
                    if (!lineUserResource.contains(TEMPLATE_FUNCTION_START_TAG) && !isFunction) continue;
                    isFunction = !lineUserResource.contains(TEMPLATE_FUNCTION_END_TAG);
                    sb.append(lineUserResource + System.lineSeparator());
                }
                functionsByResource.put(userTemplateFile.getName(), sb.toString());
            }
        }
        return functionsByResource;
    }

    private List<Map<Object, Object>> replaceValuesInYamls(HelmChartConfig helmConfig, Collection<File> generatedFiles, List<ConfigReference> valuesReferences, Map<String, Object> prodValues, Map<String, Map<String, Object>> valuesByProfile) throws IOException {
        LinkedList<Map<Object, Object>> allResources = new LinkedList<Map<Object, Object>>();
        for (File generatedFile : generatedFiles) {
            if (!generatedFile.getName().toLowerCase().matches(YAML_REG_EXP)) continue;
            YamlExpressionParser parser = YamlPath.from((InputStream[])new InputStream[]{new FileInputStream(generatedFile)});
            for (ConfigReference valueReference : valuesReferences) {
                String valueReferenceProperty = Strings.kebabToCamelCase((String)(helmConfig.getValuesRootAlias() + "." + valueReference.getProperty()));
                for (String path : valueReference.getPaths()) {
                    String expression = Optional.ofNullable(valueReference.getExpression()).filter(Strings::isNotNullOrEmpty).orElse(VALUES_START_TAG + valueReferenceProperty + VALUES_END_TAG);
                    Object found = HelmWriterSessionListener.readAndSet(parser, path, expression);
                    Object value = Optional.ofNullable(valueReference.getValue()).orElse(found);
                    if (value == null) continue;
                    String valueProfile = valueReference.getProfile();
                    Map<String, Object> values = prodValues;
                    if (Strings.isNotNullOrEmpty((String)valueProfile) && (values = valuesByProfile.get(valueProfile)) == null) {
                        values = new HashMap<String, Object>();
                        valuesByProfile.put(valueProfile, values);
                    }
                    values.put(valueReferenceProperty, value);
                }
            }
            allResources.addAll(parser.getResources());
        }
        return allResources;
    }

    private Map<String, String> createChartYaml(HelmChartConfig helmConfig, Project project, Path outputDir) throws IOException {
        Chart chart = new Chart();
        chart.setApiVersion(helmConfig.getApiVersion());
        chart.setName(helmConfig.getName());
        chart.setVersion(this.getVersion(helmConfig, project));
        chart.setDescription(helmConfig.getDescription());
        chart.setHome(helmConfig.getHome());
        chart.setSources(Arrays.asList(helmConfig.getSources()));
        chart.setMaintainers(Arrays.stream(helmConfig.getMaintainers()).map(m -> new Maintainer(m.getName(), m.getEmail(), m.getUrl())).collect(Collectors.toList()));
        chart.setIcon(helmConfig.getIcon());
        chart.setKeywords(Arrays.asList(helmConfig.getKeywords()));
        chart.setDependencies(Arrays.stream(helmConfig.getDependencies()).map(d -> new HelmDependency(d.getName(), Strings.defaultIfEmpty((String)d.getAlias(), (String)d.getName()), d.getVersion(), d.getRepository(), d.getCondition(), d.getTags())).collect(Collectors.toList()));
        Path yml = this.getChartOutputDir(helmConfig, outputDir).resolve(CHART_FILENAME).normalize();
        return this.writeFileAsYaml(chart, yml);
    }

    private Map<String, String> writeFileAsYaml(Object data, Path file) throws IOException {
        String value = Serialization.asYaml((Object)data);
        return this.writeFile(value, file);
    }

    private Map<String, String> writeFile(String value, Path file) throws IOException {
        try (FileWriter writer = new FileWriter(file.toFile(), true);){
            writer.write(value);
            Map<String, String> map = Collections.singletonMap(file.toString(), value);
            return map;
        }
    }

    private String getHelmClassifier(Map<String, String> artifacts) {
        if (artifacts.keySet().stream().anyMatch(a -> a.contains(OPENSHIFT))) {
            return OPENSHIFT_CLASSIFIER;
        }
        return KUBERNETES_CLASSIFIER;
    }

    private Path getChartOutputDir(HelmChartConfig helmConfig, Path outputDir) {
        return outputDir.resolve(helmConfig.getName());
    }

    private static List<File> listYamls(Path directory) {
        return Stream.of((Object[])Optional.ofNullable(directory.toFile().listFiles()).orElse(new File[0])).filter(File::isFile).filter(f -> f.getName().toLowerCase().matches(YAML_REG_EXP)).collect(Collectors.toList());
    }

    private static Object readAndSet(YamlExpressionParser parser, String path, String expression) {
        return parser.readSingleAndReplace(path, START_EXPRESSION_TOKEN + expression.replaceAll(Pattern.quote(System.lineSeparator()), SEPARATOR_TOKEN) + END_EXPRESSION_TOKEN);
    }

    private static Map<String, Object> toMultiValueMap(Map<String, Object> map) {
        HashMap<String, Object> multiValueMap = new HashMap<String, Object>();
        map.forEach((k, v) -> {
            String[] nodes = k.split(Pattern.quote("."));
            if (nodes.length == 1) {
                multiValueMap.put((String)k, v);
            } else {
                Map auxKeyValue = multiValueMap;
                for (int index = 0; index < nodes.length - 1; ++index) {
                    String nodeName = nodes[index];
                    Object nodeKeyValue = auxKeyValue.get(nodeName);
                    if (nodeKeyValue == null || !(nodeKeyValue instanceof Map)) {
                        nodeKeyValue = new HashMap();
                    }
                    auxKeyValue.put(nodes[index], nodeKeyValue);
                    auxKeyValue = (Map)nodeKeyValue;
                }
                auxKeyValue.put(nodes[nodes.length - 1], v);
            }
        });
        return multiValueMap;
    }
}

