/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.helm.config;

import io.dekorate.helm.config.ValueReference;
import io.dekorate.helm.config.ValueReferenceFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ValueReferenceFluentImpl<A extends ValueReferenceFluent<A>>
extends BaseFluent<A>
implements ValueReferenceFluent<A> {
    private String property;
    private List<String> jsonPaths = new ArrayList<String>();
    private String profile;
    private String value;

    public ValueReferenceFluentImpl() {
    }

    public ValueReferenceFluentImpl(ValueReference instance) {
        this.withProperty(instance.getProperty());
        this.withJsonPaths(instance.getJsonPaths());
        this.withProfile(instance.getProfile());
        this.withValue(instance.getValue());
    }

    @Override
    public String getProperty() {
        return this.property;
    }

    @Override
    public A withProperty(String property) {
        this.property = property;
        return (A)this;
    }

    @Override
    public Boolean hasProperty() {
        return this.property != null;
    }

    @Override
    public A withJsonPaths(String ... jsonPaths) {
        if (this.jsonPaths != null) {
            this.jsonPaths.clear();
        }
        if (jsonPaths != null) {
            for (String item : jsonPaths) {
                this.addToJsonPaths(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getJsonPaths() {
        int size = this.jsonPaths != null ? this.jsonPaths.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.jsonPaths) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToJsonPaths(Integer index, String item) {
        if (this.jsonPaths == null) {
            this.jsonPaths = new ArrayList<String>();
        }
        this.jsonPaths.add(index, item);
        return (A)this;
    }

    @Override
    public A setToJsonPaths(Integer index, String item) {
        if (this.jsonPaths == null) {
            this.jsonPaths = new ArrayList<String>();
        }
        this.jsonPaths.set(index, item);
        return (A)this;
    }

    @Override
    public A addToJsonPaths(String ... items) {
        if (this.jsonPaths == null) {
            this.jsonPaths = new ArrayList<String>();
        }
        for (String item : items) {
            this.jsonPaths.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToJsonPaths(Collection<String> items) {
        if (this.jsonPaths == null) {
            this.jsonPaths = new ArrayList<String>();
        }
        for (String item : items) {
            this.jsonPaths.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromJsonPaths(String ... items) {
        for (String item : items) {
            if (this.jsonPaths == null) continue;
            this.jsonPaths.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromJsonPaths(Collection<String> items) {
        for (String item : items) {
            if (this.jsonPaths == null) continue;
            this.jsonPaths.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasJsonPaths() {
        return this.jsonPaths != null && !this.jsonPaths.isEmpty();
    }

    @Override
    public String getProfile() {
        return this.profile;
    }

    @Override
    public A withProfile(String profile) {
        this.profile = profile;
        return (A)this;
    }

    @Override
    public Boolean hasProfile() {
        return this.profile != null;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public A withValue(String value) {
        this.value = value;
        return (A)this;
    }

    @Override
    public Boolean hasValue() {
        return this.value != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueReferenceFluentImpl that = (ValueReferenceFluentImpl)o;
        if (this.property != null ? !this.property.equals(that.property) : that.property != null) {
            return false;
        }
        if (this.jsonPaths != null ? !this.jsonPaths.equals(that.jsonPaths) : that.jsonPaths != null) {
            return false;
        }
        if (this.profile != null ? !this.profile.equals(that.profile) : that.profile != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        return Objects.hash(this.property, this.jsonPaths, this.profile, this.value, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.property != null) {
            sb.append("property:");
            sb.append(this.property + ",");
        }
        if (this.jsonPaths != null && !this.jsonPaths.isEmpty()) {
            sb.append("jsonPaths:");
            sb.append(this.jsonPaths + ",");
        }
        if (this.profile != null) {
            sb.append("profile:");
            sb.append(this.profile + ",");
        }
        if (this.value != null) {
            sb.append("value:");
            sb.append(this.value);
        }
        sb.append("}");
        return sb.toString();
    }
}

