/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.helm.processor;

import com.fasterxml.jackson.databind.JsonNode;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import io.dekorate.ConfigReference;
import io.dekorate.Logger;
import io.dekorate.LoggerFactory;
import io.dekorate.Session;
import io.dekorate.WithConfigReferences;
import io.dekorate.helm.config.HelmChartConfig;
import io.dekorate.helm.config.ValueReference;
import io.dekorate.helm.model.Chart;
import io.dekorate.helm.model.HelmDependency;
import io.dekorate.helm.model.Maintainer;
import io.dekorate.helm.util.HelmTarArchiver;
import io.dekorate.processor.SimpleFileWriter;
import io.dekorate.project.Project;
import io.dekorate.utils.Serialization;
import io.dekorate.utils.Strings;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HelmFileWriter
extends SimpleFileWriter {
    private static final String YAML = ".yaml";
    private static final String CHART_FILENAME = "Chart.yaml";
    private static final String VALUES = "values";
    private static final String CHART_API_VERSION = "v1";
    private static final String TEMPLATES = "templates";
    private static final String CHARTS = "charts";
    private static final String NOTES = "NOTES.txt";
    private static final String KUBERNETES_CLASSIFIER = "helm";
    private static final String OPENSHIFT_CLASSIFIER = "helmshift";
    private static final String OPENSHIFT = "openshift";
    private static final String KIND = "kind";
    private static final String VALUES_START_TAG = "{{ .Values.";
    private static final String VALUES_END_TAG = " }}";
    private static final String EMPTY = "";
    private static final boolean APPEND = true;
    private static final Logger LOGGER = LoggerFactory.getLogger();

    public HelmFileWriter(Project project) {
        super(project);
    }

    public Map<String, String> write(Session session) {
        Map artifacts = super.write(session);
        session.getConfigurationRegistry().get(HelmChartConfig.class).ifPresent(helmConfig -> {
            if (helmConfig.isEnabled()) {
                this.validateHelmConfig((HelmChartConfig)((Object)helmConfig));
                List<ConfigReference> valuesReferences = this.getValuesReferences((HelmChartConfig)((Object)helmConfig), session);
                try {
                    LOGGER.info(String.format("Creating Helm Chart \"%s\"", helmConfig.getName()));
                    HashMap<String, Object> prodValues = new HashMap<String, Object>();
                    HashMap<String, Map<String, Object>> valuesByProfile = new HashMap<String, Map<String, Object>>();
                    artifacts.putAll(this.processSourceFiles((HelmChartConfig)((Object)helmConfig), valuesReferences, (Map<String, Object>)prodValues, (Map<String, Map<String, Object>>)valuesByProfile));
                    artifacts.putAll(this.createChartYaml((HelmChartConfig)((Object)helmConfig)));
                    artifacts.putAll(this.createValuesYaml((HelmChartConfig)((Object)helmConfig), (Map<String, Object>)prodValues, (Map<String, Map<String, Object>>)valuesByProfile));
                    artifacts.putAll(this.createTarball((HelmChartConfig)((Object)helmConfig), artifacts, valuesByProfile.keySet()));
                    artifacts.putAll(this.createEmptyChartFolder((HelmChartConfig)((Object)helmConfig)));
                    artifacts.putAll(this.addNotesIntoTemplatesFolder((HelmChartConfig)((Object)helmConfig)));
                }
                catch (IOException e) {
                    throw new RuntimeException("Error writing resources", e);
                }
            }
        });
        return artifacts;
    }

    private void validateHelmConfig(HelmChartConfig helmConfig) {
        if (Strings.isNullOrEmpty((String)helmConfig.getName())) {
            throw new RuntimeException("Helm Chart name is required!");
        }
    }

    private Map<String, String> addNotesIntoTemplatesFolder(HelmChartConfig helmConfig) throws IOException {
        InputStream notesInputStream = HelmFileWriter.class.getResourceAsStream("/NOTES.txt");
        Path outputDir = this.getChartOutputDir(helmConfig).resolve(TEMPLATES).resolve(NOTES);
        Files.copy(notesInputStream, outputDir, new CopyOption[0]);
        return Collections.singletonMap(outputDir.toString(), EMPTY);
    }

    private Map<String, String> createEmptyChartFolder(HelmChartConfig helmConfig) throws IOException {
        Path emptyChartsDir = this.getChartOutputDir(helmConfig).resolve(CHARTS);
        Files.createDirectories(emptyChartsDir, new FileAttribute[0]);
        return Collections.singletonMap(emptyChartsDir.toString(), EMPTY);
    }

    private List<ConfigReference> getValuesReferences(HelmChartConfig helmBuildConfig, Session session) {
        LinkedList<ConfigReference> configReferences = new LinkedList<ConfigReference>();
        for (WithConfigReferences decorator : session.getResourceRegistry().getConfigReferences()) {
            configReferences.addAll(decorator.getConfigReferences());
        }
        Stream.of(helmBuildConfig.getValues()).map(this::toConfigReference).forEach(configReferences::add);
        return configReferences;
    }

    private ConfigReference toConfigReference(ValueReference valueReference) {
        return new ConfigReference(valueReference.getProperty(), valueReference.getJsonPaths(), (Object)(valueReference.getValue().isEmpty() ? null : valueReference.getValue()), valueReference.getProfile());
    }

    private Map<String, String> createValuesYaml(HelmChartConfig helmConfig, Map<String, Object> prodValues, Map<String, Map<String, Object>> valuesByProfile) throws IOException {
        HashMap<String, String> artifacts = new HashMap<String, String>();
        for (Map.Entry<String, Map<String, Object>> valuesInProfile : valuesByProfile.entrySet()) {
            String profile = valuesInProfile.getKey();
            Map<String, Object> values = valuesInProfile.getValue();
            for (Map.Entry<String, Object> prodValue : prodValues.entrySet()) {
                if (values.containsKey(prodValue.getKey())) continue;
                values.put(prodValue.getKey(), prodValue.getValue());
            }
            artifacts.putAll(this.writeFileAsYaml(HelmFileWriter.toMultiValueMap(values), this.getChartOutputDir(helmConfig).resolve("values." + profile + YAML)));
        }
        artifacts.putAll(this.writeFileAsYaml(HelmFileWriter.toMultiValueMap(prodValues), this.getChartOutputDir(helmConfig).resolve("values.yaml")));
        return artifacts;
    }

    private Map<String, String> createTarball(HelmChartConfig helmConfig, Map<String, String> artifacts, Set<String> profiles) throws IOException {
        File tarballFile = this.getOutputDir().resolve(KUBERNETES_CLASSIFIER).resolve(String.format("%s-%s-%s.%s", helmConfig.getName(), this.getVersion(helmConfig), this.getHelmClassifier(artifacts), helmConfig.getExtension())).toFile();
        LOGGER.debug(String.format("Creating Helm configuration Tarball: '%s'", tarballFile));
        Path helmSources = this.getChartOutputDir(helmConfig);
        ArrayList<File> yamls = new ArrayList<File>();
        yamls.add(helmSources.resolve(CHART_FILENAME).toFile());
        yamls.add(helmSources.resolve("values.yaml").toFile());
        for (String profile : profiles) {
            yamls.add(helmSources.resolve("values." + profile + YAML).toFile());
        }
        yamls.addAll(HelmFileWriter.listYamls(helmSources.resolve(TEMPLATES)));
        HelmTarArchiver.createTarBall(tarballFile, helmSources.toFile(), yamls, helmConfig.getExtension(), tae -> tae.setName(String.format("%s/%s", helmConfig.getName(), tae.getName())));
        return Collections.singletonMap(tarballFile.toString(), null);
    }

    private String getVersion(HelmChartConfig helmConfig) {
        if (Strings.isNullOrEmpty((String)helmConfig.getVersion())) {
            return this.getProject().getBuildInfo().getVersion();
        }
        return helmConfig.getVersion();
    }

    private Map<String, String> processSourceFiles(HelmChartConfig helmConfig, List<ConfigReference> valuesReferences, Map<String, Object> prodValues, Map<String, Map<String, Object>> valuesByProfile) throws IOException {
        Path templatesDir = this.getChartOutputDir(helmConfig).resolve(TEMPLATES);
        Files.createDirectories(templatesDir, new FileAttribute[0]);
        List<String> yamlsContent = this.replaceValuesInYamls(valuesReferences, prodValues, valuesByProfile);
        for (String yamlContent : yamlsContent) {
            List resources = Serialization.unmarshalAsListOfMaps((String)yamlContent);
            for (Map resource : resources) {
                String kind = (String)resource.get(KIND);
                Path targetFile = templatesDir.resolve(kind.toLowerCase() + YAML);
                String adaptedString = Serialization.yamlMapper().writeValueAsString((Object)resource).replaceAll(Pattern.quote("\"{{ .Values."), VALUES_START_TAG).replaceAll(Pattern.quote(" }}\""), VALUES_END_TAG);
                this.writeFile(adaptedString, targetFile);
            }
        }
        return Collections.emptyMap();
    }

    private List<String> replaceValuesInYamls(List<ConfigReference> valuesReferences, Map<String, Object> prodValues, Map<String, Map<String, Object>> valuesByProfile) throws IOException {
        LinkedList<String> yamlsContent = new LinkedList<String>();
        for (File file : HelmFileWriter.listYamls(this.getOutputDir())) {
            List yaml = Serialization.unmarshalAsListOfMaps((Path)file.toPath());
            String json = Serialization.jsonMapper().writeValueAsString((Object)yaml);
            for (ConfigReference valueReference : valuesReferences) {
                String valueReferenceProperty = Strings.kebabToCamelCase((String)valueReference.getProperty());
                DocumentContext jsonContext = JsonPath.parse((String)json);
                Object currentValue = null;
                for (String jsonPath : valueReference.getJsonPaths()) {
                    try {
                        currentValue = jsonContext.read(jsonPath, Object.class, new Predicate[0]);
                    }
                    catch (PathNotFoundException ex) {
                        LOGGER.warning(String.format("Property '%s' is ignored in Helm generation because the json Path '%s' was not found. ", valueReferenceProperty, jsonPath));
                        continue;
                    }
                    json = jsonContext.set(jsonPath, (Object)(VALUES_START_TAG + valueReferenceProperty + VALUES_END_TAG), new Predicate[0]).jsonString();
                    Object value = valueReference.getValue();
                    if (value == null) {
                        value = currentValue instanceof List && !((List)currentValue).isEmpty() ? ((List)currentValue).get(0) : currentValue;
                    }
                    String valueProfile = valueReference.getProfile();
                    Map<String, Object> values = prodValues;
                    if (Strings.isNotNullOrEmpty((String)valueProfile) && (values = valuesByProfile.get(valueProfile)) == null) {
                        values = new HashMap<String, Object>();
                        valuesByProfile.put(valueProfile, values);
                    }
                    values.put(valueReferenceProperty, value);
                }
            }
            StringBuilder sb = new StringBuilder();
            JsonNode jsonTree = Serialization.jsonMapper().readTree(json);
            for (JsonNode jsonElement : jsonTree) {
                sb.append(Serialization.yamlMapper().writeValueAsString((Object)jsonElement));
            }
            yamlsContent.add(sb.toString());
        }
        return yamlsContent;
    }

    private Map<String, String> createChartYaml(HelmChartConfig helmConfig) throws IOException {
        Chart chart = new Chart();
        chart.setApiVersion(CHART_API_VERSION);
        chart.setName(helmConfig.getName());
        chart.setVersion(this.getVersion(helmConfig));
        chart.setDescription(helmConfig.getDescription());
        chart.setHome(helmConfig.getHome());
        chart.setSources(Arrays.asList(helmConfig.getSources()));
        chart.setMaintainers(Arrays.stream(helmConfig.getMaintainers()).map(m -> new Maintainer(m.getName(), m.getEmail(), m.getUrl())).collect(Collectors.toList()));
        chart.setIcon(helmConfig.getIcon());
        chart.setKeywords(Arrays.asList(helmConfig.getKeywords()));
        chart.setDependencies(Arrays.stream(helmConfig.getDependencies()).map(d -> new HelmDependency(d.getName(), d.getVersion(), d.getRepository())).collect(Collectors.toList()));
        Path yml = this.getChartOutputDir(helmConfig).resolve(CHART_FILENAME).normalize();
        return this.writeFileAsYaml(chart, yml);
    }

    private Map<String, String> writeFileAsYaml(Object data, Path file) throws IOException {
        String value = Serialization.asYaml((Object)data);
        return this.writeFile(value, file);
    }

    private Map<String, String> writeFile(String value, Path file) throws IOException {
        try (FileWriter writer = new FileWriter(file.toFile(), true);){
            writer.write(value);
            Map<String, String> map = Collections.singletonMap(file.toString(), value);
            return map;
        }
    }

    private String getHelmClassifier(Map<String, String> artifacts) {
        if (artifacts.keySet().stream().anyMatch(a -> a.contains(OPENSHIFT))) {
            return OPENSHIFT_CLASSIFIER;
        }
        return KUBERNETES_CLASSIFIER;
    }

    private Path getChartOutputDir(HelmChartConfig helmConfig) {
        return this.getOutputDir().resolve(KUBERNETES_CLASSIFIER).resolve(helmConfig.getName());
    }

    private static List<File> listYamls(Path directory) {
        return Stream.of((Object[])Optional.ofNullable(directory.toFile().listFiles()).orElse(new File[0])).filter(File::isFile).filter(f -> f.getName().toLowerCase().matches(".*?\\.ya?ml$")).collect(Collectors.toList());
    }

    private static Map<String, Object> toMultiValueMap(Map<String, Object> map) {
        HashMap<String, Object> multiValueMap = new HashMap<String, Object>();
        map.forEach((k, v) -> {
            String[] nodes = k.split(Pattern.quote("."));
            if (nodes.length == 1) {
                multiValueMap.put((String)k, v);
            } else {
                Map auxKeyValue = multiValueMap;
                for (int index = 0; index < nodes.length - 1; ++index) {
                    String nodeName = nodes[index];
                    Object nodeKeyValue = auxKeyValue.get(nodeName);
                    if (nodeKeyValue == null || !(nodeKeyValue instanceof Map)) {
                        nodeKeyValue = new HashMap();
                    }
                    auxKeyValue.put(nodes[index], nodeKeyValue);
                    auxKeyValue = (Map)nodeKeyValue;
                }
                auxKeyValue.put(nodes[nodes.length - 1], v);
            }
        });
        return multiValueMap;
    }
}

