package io.dekorate.helm.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.dekorate.kubernetes.config.ConfigurationFluentImpl;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
public class HelmChartConfigFluentImpl<A extends io.dekorate.helm.config.HelmChartConfigFluent<A>> extends io.dekorate.kubernetes.config.ConfigurationFluentImpl<A> implements io.dekorate.helm.config.HelmChartConfigFluent<A>{
  public HelmChartConfigFluentImpl() {
  }
  public HelmChartConfigFluentImpl(io.dekorate.helm.config.HelmChartConfig instance) {
    this.withProject(instance.getProject()); 
    this.withAttributes(instance.getAttributes()); 
    this.withEnabled(instance.getEnabled()); 
    this.withName(instance.getName()); 
    this.withExtension(instance.getExtension()); 
    this.withDescription(instance.getDescription()); 
    this.withVersion(instance.getVersion()); 
    this.withIcon(instance.getIcon()); 
    this.withHome(instance.getHome()); 
    this.withKeywords(instance.getKeywords()); 
    this.withSources(instance.getSources()); 
    this.withMaintainers(instance.getMaintainers()); 
    this.withDependencies(instance.getDependencies()); 
    this.withValues(instance.getValues()); 
  }
  private java.lang.Boolean enabled;
  private java.lang.String name;
  private java.lang.String extension;
  private java.lang.String description;
  private java.lang.String version;
  private java.lang.String icon;
  private java.lang.String home;
  private java.util.List<java.lang.String> keywords = new java.util.ArrayList<java.lang.String>();
  private java.util.List<java.lang.String> sources = new java.util.ArrayList<java.lang.String>();
  private java.util.ArrayList<io.dekorate.helm.config.MaintainerBuilder> maintainers = new java.util.ArrayList<io.dekorate.helm.config.MaintainerBuilder>();
  private java.util.ArrayList<io.dekorate.helm.config.HelmDependencyBuilder> dependencies = new java.util.ArrayList<io.dekorate.helm.config.HelmDependencyBuilder>();
  private java.util.ArrayList<io.dekorate.helm.config.ValueReferenceBuilder> values = new java.util.ArrayList<io.dekorate.helm.config.ValueReferenceBuilder>();
  public java.lang.Boolean getEnabled() {
    return this.enabled;
  }
  public A withEnabled(java.lang.Boolean enabled) {
    this.enabled=enabled; return (A) this;
  }
  public java.lang.Boolean hasEnabled() {
    return this.enabled != null;
  }
  public java.lang.String getName() {
    return this.name;
  }
  public A withName(java.lang.String name) {
    this.name=name; return (A) this;
  }
  public java.lang.Boolean hasName() {
    return this.name != null;
  }
  
  /**
   * Method is deprecated. use withName instead.
   */
  @java.lang.Deprecated
  public A withNewName(java.lang.String arg0) {
    return (A)withName(new String(arg0));
  }
  public java.lang.String getExtension() {
    return this.extension;
  }
  public A withExtension(java.lang.String extension) {
    this.extension=extension; return (A) this;
  }
  public java.lang.Boolean hasExtension() {
    return this.extension != null;
  }
  
  /**
   * Method is deprecated. use withExtension instead.
   */
  @java.lang.Deprecated
  public A withNewExtension(java.lang.String arg0) {
    return (A)withExtension(new String(arg0));
  }
  public java.lang.String getDescription() {
    return this.description;
  }
  public A withDescription(java.lang.String description) {
    this.description=description; return (A) this;
  }
  public java.lang.Boolean hasDescription() {
    return this.description != null;
  }
  
  /**
   * Method is deprecated. use withDescription instead.
   */
  @java.lang.Deprecated
  public A withNewDescription(java.lang.String arg0) {
    return (A)withDescription(new String(arg0));
  }
  public java.lang.String getVersion() {
    return this.version;
  }
  public A withVersion(java.lang.String version) {
    this.version=version; return (A) this;
  }
  public java.lang.Boolean hasVersion() {
    return this.version != null;
  }
  
  /**
   * Method is deprecated. use withVersion instead.
   */
  @java.lang.Deprecated
  public A withNewVersion(java.lang.String arg0) {
    return (A)withVersion(new String(arg0));
  }
  public java.lang.String getIcon() {
    return this.icon;
  }
  public A withIcon(java.lang.String icon) {
    this.icon=icon; return (A) this;
  }
  public java.lang.Boolean hasIcon() {
    return this.icon != null;
  }
  
  /**
   * Method is deprecated. use withIcon instead.
   */
  @java.lang.Deprecated
  public A withNewIcon(java.lang.String arg0) {
    return (A)withIcon(new String(arg0));
  }
  public java.lang.String getHome() {
    return this.home;
  }
  public A withHome(java.lang.String home) {
    this.home=home; return (A) this;
  }
  public java.lang.Boolean hasHome() {
    return this.home != null;
  }
  
  /**
   * Method is deprecated. use withHome instead.
   */
  @java.lang.Deprecated
  public A withNewHome(java.lang.String arg0) {
    return (A)withHome(new String(arg0));
  }
  public A withKeywords(java.lang.String... keywords) {
    if (this.keywords != null) {this.keywords.clear();}
    if (keywords != null) {for (java.lang.String item :keywords){ this.addToKeywords(item);}} return (A) this;
  }
  public java.lang.String[] getKeywords() {
    //This needs to work with primitives, so we use arrays.
int size = keywords != null ? keywords.size() : 0;
java.lang.String[] result = new java.lang.String[size];
if (size == 0) {
   return result;
}
int index = 0;
for (java.lang.String item : keywords) {
    result[index++]=item;
}
return result;

  }
  public A addToKeywords(java.lang.Integer index,java.lang.String item) {
    if (this.keywords == null) {this.keywords = new java.util.ArrayList<java.lang.String>();}
    this.keywords.add(index, item);
    return (A)this;
  }
  public A setToKeywords(java.lang.Integer index,java.lang.String item) {
    if (this.keywords == null) {this.keywords = new java.util.ArrayList<java.lang.String>();}
    this.keywords.set(index, item); return (A)this;
  }
  public A addToKeywords(java.lang.String... items) {
    if (this.keywords == null) {this.keywords = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.keywords.add(item);} return (A)this;
  }
  public A addAllToKeywords(java.util.Collection<java.lang.String> items) {
    if (this.keywords == null) {this.keywords = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.keywords.add(item);} return (A)this;
  }
  public A removeFromKeywords(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.keywords!= null){ this.keywords.remove(item);}} return (A)this;
  }
  public A removeAllFromKeywords(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.keywords!= null){ this.keywords.remove(item);}} return (A)this;
  }
  public java.lang.Boolean hasKeywords() {
    return keywords != null && !keywords.isEmpty();
  }
  public A addNewKeyword(java.lang.String arg0) {
    return (A)addToKeywords(new String(arg0));
  }
  public A withSources(java.lang.String... sources) {
    if (this.sources != null) {this.sources.clear();}
    if (sources != null) {for (java.lang.String item :sources){ this.addToSources(item);}} return (A) this;
  }
  public java.lang.String[] getSources() {
    //This needs to work with primitives, so we use arrays.
int size = sources != null ? sources.size() : 0;
java.lang.String[] result = new java.lang.String[size];
if (size == 0) {
   return result;
}
int index = 0;
for (java.lang.String item : sources) {
    result[index++]=item;
}
return result;

  }
  public A addToSources(java.lang.Integer index,java.lang.String item) {
    if (this.sources == null) {this.sources = new java.util.ArrayList<java.lang.String>();}
    this.sources.add(index, item);
    return (A)this;
  }
  public A setToSources(java.lang.Integer index,java.lang.String item) {
    if (this.sources == null) {this.sources = new java.util.ArrayList<java.lang.String>();}
    this.sources.set(index, item); return (A)this;
  }
  public A addToSources(java.lang.String... items) {
    if (this.sources == null) {this.sources = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.sources.add(item);} return (A)this;
  }
  public A addAllToSources(java.util.Collection<java.lang.String> items) {
    if (this.sources == null) {this.sources = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.sources.add(item);} return (A)this;
  }
  public A removeFromSources(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.sources!= null){ this.sources.remove(item);}} return (A)this;
  }
  public A removeAllFromSources(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.sources!= null){ this.sources.remove(item);}} return (A)this;
  }
  public java.lang.Boolean hasSources() {
    return sources != null && !sources.isEmpty();
  }
  public A addNewSource(java.lang.String arg0) {
    return (A)addToSources(new String(arg0));
  }
  public A withMaintainers(io.dekorate.helm.config.Maintainer... maintainers) {
    if (this.maintainers != null) {this.maintainers.clear();}
    if (maintainers != null) {for (io.dekorate.helm.config.Maintainer item :maintainers){ this.addToMaintainers(item);}} return (A) this;
  }
  
  /**
   * This method has been deprecated, please use method buildMaintainers instead.
   */
  @java.lang.Deprecated
  public io.dekorate.helm.config.Maintainer[] getMaintainers() {
    int size = maintainers != null ? maintainers.size() : 0;
io.dekorate.helm.config.Maintainer[] result = new io.dekorate.helm.config.Maintainer[size];
if (size == 0) {
   return result;
}
int index = 0;
for (io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.dekorate.helm.config.Maintainer,?> builder : maintainers) {
    result[index++]=builder.build();
}
return result;

  }
  public io.dekorate.helm.config.Maintainer[] buildMaintainers() {
    int size = maintainers != null ? maintainers.size() : 0;
io.dekorate.helm.config.Maintainer[] result = new io.dekorate.helm.config.Maintainer[size];
if (size == 0) {
   return result;
}
int index = 0;
for (io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.dekorate.helm.config.Maintainer,?> builder : maintainers) {
    result[index++]=builder.build();
}
return result;

  }
  public io.dekorate.helm.config.Maintainer buildMaintainer(java.lang.Integer index) {
    return this.maintainers.get(index).build();
  }
  public io.dekorate.helm.config.Maintainer buildFirstMaintainer() {
    return this.maintainers.get(0).build();
  }
  public io.dekorate.helm.config.Maintainer buildLastMaintainer() {
    return this.maintainers.get(maintainers.size() - 1).build();
  }
  public io.dekorate.helm.config.Maintainer buildMatchingMaintainer(java.util.function.Predicate<io.dekorate.helm.config.MaintainerBuilder> predicate) {
    for (io.dekorate.helm.config.MaintainerBuilder item: maintainers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingMaintainer(java.util.function.Predicate<io.dekorate.helm.config.MaintainerBuilder> predicate) {
    for (io.dekorate.helm.config.MaintainerBuilder item: maintainers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A addToMaintainers(java.lang.Integer index,io.dekorate.helm.config.Maintainer item) {
    if (this.maintainers == null) {this.maintainers = new java.util.ArrayList<io.dekorate.helm.config.MaintainerBuilder>();}
    io.dekorate.helm.config.MaintainerBuilder builder = new io.dekorate.helm.config.MaintainerBuilder(item);_visitables.get("maintainers").add(index >= 0 ? index : _visitables.get("maintainers").size(), builder);this.maintainers.add(index >= 0 ? index : maintainers.size(), builder); return (A)this;
  }
  public A setToMaintainers(java.lang.Integer index,io.dekorate.helm.config.Maintainer item) {
    if (this.maintainers == null) {this.maintainers = new java.util.ArrayList<io.dekorate.helm.config.MaintainerBuilder>();}
    io.dekorate.helm.config.MaintainerBuilder builder = new io.dekorate.helm.config.MaintainerBuilder(item);
    if (index < 0 || index >= _visitables.get("maintainers").size()) { _visitables.get("maintainers").add(builder); } else { _visitables.get("maintainers").set(index, builder);}
    if (index < 0 || index >= maintainers.size()) { maintainers.add(builder); } else { maintainers.set(index, builder);}
     return (A)this;
  }
  public A addToMaintainers(io.dekorate.helm.config.Maintainer... items) {
    if (this.maintainers == null) {this.maintainers = new java.util.ArrayList<io.dekorate.helm.config.MaintainerBuilder>();}
    for (io.dekorate.helm.config.Maintainer item : items) {io.dekorate.helm.config.MaintainerBuilder builder = new io.dekorate.helm.config.MaintainerBuilder(item);_visitables.get("maintainers").add(builder);this.maintainers.add(builder);} return (A)this;
  }
  public A addAllToMaintainers(java.util.Collection<io.dekorate.helm.config.Maintainer> items) {
    if (this.maintainers == null) {this.maintainers = new java.util.ArrayList<io.dekorate.helm.config.MaintainerBuilder>();}
    for (io.dekorate.helm.config.Maintainer item : items) {io.dekorate.helm.config.MaintainerBuilder builder = new io.dekorate.helm.config.MaintainerBuilder(item);_visitables.get("maintainers").add(builder);this.maintainers.add(builder);} return (A)this;
  }
  public A removeFromMaintainers(io.dekorate.helm.config.Maintainer... items) {
    for (io.dekorate.helm.config.Maintainer item : items) {io.dekorate.helm.config.MaintainerBuilder builder = new io.dekorate.helm.config.MaintainerBuilder(item);_visitables.get("maintainers").remove(builder);if (this.maintainers != null) {this.maintainers.remove(builder);}} return (A)this;
  }
  public A removeAllFromMaintainers(java.util.Collection<io.dekorate.helm.config.Maintainer> items) {
    for (io.dekorate.helm.config.Maintainer item : items) {io.dekorate.helm.config.MaintainerBuilder builder = new io.dekorate.helm.config.MaintainerBuilder(item);_visitables.get("maintainers").remove(builder);if (this.maintainers != null) {this.maintainers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromMaintainers(java.util.function.Predicate<io.dekorate.helm.config.MaintainerBuilder> predicate) {
    if (maintainers == null) return (A) this;
    final Iterator<io.dekorate.helm.config.MaintainerBuilder> each = maintainers.iterator();
    final List visitables = _visitables.get("maintainers");
    while (each.hasNext()) {
      io.dekorate.helm.config.MaintainerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public java.lang.Boolean hasMaintainers() {
    return maintainers != null && !maintainers.isEmpty();
  }
  public A addNewMaintainer(java.lang.String name,java.lang.String email,java.lang.String url) {
    return (A)addToMaintainers(new Maintainer(name, email, url));
  }
  public io.dekorate.helm.config.HelmChartConfigFluent.MaintainersNested<A> addNewMaintainer() {
    return new io.dekorate.helm.config.HelmChartConfigFluentImpl.MaintainersNestedImpl();
  }
  public io.dekorate.helm.config.HelmChartConfigFluent.MaintainersNested<A> addNewMaintainerLike(io.dekorate.helm.config.Maintainer item) {
    return new io.dekorate.helm.config.HelmChartConfigFluentImpl.MaintainersNestedImpl(-1, item);
  }
  public io.dekorate.helm.config.HelmChartConfigFluent.MaintainersNested<A> setNewMaintainerLike(java.lang.Integer index,io.dekorate.helm.config.Maintainer item) {
    return new io.dekorate.helm.config.HelmChartConfigFluentImpl.MaintainersNestedImpl(index, item);
  }
  public io.dekorate.helm.config.HelmChartConfigFluent.MaintainersNested<A> editMaintainer(java.lang.Integer index) {
    if (maintainers.size() <= index) throw new RuntimeException("Can't edit maintainers. Index exceeds size.");
    return setNewMaintainerLike(index, buildMaintainer(index));
  }
  public io.dekorate.helm.config.HelmChartConfigFluent.MaintainersNested<A> editFirstMaintainer() {
    if (maintainers.size() == 0) throw new RuntimeException("Can't edit first maintainers. The list is empty.");
    return setNewMaintainerLike(0, buildMaintainer(0));
  }
  public io.dekorate.helm.config.HelmChartConfigFluent.MaintainersNested<A> editLastMaintainer() {
    int index = maintainers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last maintainers. The list is empty.");
    return setNewMaintainerLike(index, buildMaintainer(index));
  }
  public io.dekorate.helm.config.HelmChartConfigFluent.MaintainersNested<A> editMatchingMaintainer(java.util.function.Predicate<io.dekorate.helm.config.MaintainerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<maintainers.size();i++) { 
    if (predicate.test(maintainers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching maintainers. No match found.");
    return setNewMaintainerLike(index, buildMaintainer(index));
  }
  public A withDependencies(io.dekorate.helm.config.HelmDependency... dependencies) {
    if (this.dependencies != null) {this.dependencies.clear();}
    if (dependencies != null) {for (io.dekorate.helm.config.HelmDependency item :dependencies){ this.addToDependencies(item);}} return (A) this;
  }
  
  /**
   * This method has been deprecated, please use method buildDependencies instead.
   */
  @java.lang.Deprecated
  public io.dekorate.helm.config.HelmDependency[] getDependencies() {
    int size = dependencies != null ? dependencies.size() : 0;
io.dekorate.helm.config.HelmDependency[] result = new io.dekorate.helm.config.HelmDependency[size];
if (size == 0) {
   return result;
}
int index = 0;
for (io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.dekorate.helm.config.HelmDependency,?> builder : dependencies) {
    result[index++]=builder.build();
}
return result;

  }
  public io.dekorate.helm.config.HelmDependency[] buildDependencies() {
    int size = dependencies != null ? dependencies.size() : 0;
io.dekorate.helm.config.HelmDependency[] result = new io.dekorate.helm.config.HelmDependency[size];
if (size == 0) {
   return result;
}
int index = 0;
for (io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.dekorate.helm.config.HelmDependency,?> builder : dependencies) {
    result[index++]=builder.build();
}
return result;

  }
  public io.dekorate.helm.config.HelmDependency buildDependency(java.lang.Integer index) {
    return this.dependencies.get(index).build();
  }
  public io.dekorate.helm.config.HelmDependency buildFirstDependency() {
    return this.dependencies.get(0).build();
  }
  public io.dekorate.helm.config.HelmDependency buildLastDependency() {
    return this.dependencies.get(dependencies.size() - 1).build();
  }
  public io.dekorate.helm.config.HelmDependency buildMatchingDependency(java.util.function.Predicate<io.dekorate.helm.config.HelmDependencyBuilder> predicate) {
    for (io.dekorate.helm.config.HelmDependencyBuilder item: dependencies) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingDependency(java.util.function.Predicate<io.dekorate.helm.config.HelmDependencyBuilder> predicate) {
    for (io.dekorate.helm.config.HelmDependencyBuilder item: dependencies) { if(predicate.test(item)){ return true;} } return false;
  }
  public A addToDependencies(java.lang.Integer index,io.dekorate.helm.config.HelmDependency item) {
    if (this.dependencies == null) {this.dependencies = new java.util.ArrayList<io.dekorate.helm.config.HelmDependencyBuilder>();}
    io.dekorate.helm.config.HelmDependencyBuilder builder = new io.dekorate.helm.config.HelmDependencyBuilder(item);_visitables.get("dependencies").add(index >= 0 ? index : _visitables.get("dependencies").size(), builder);this.dependencies.add(index >= 0 ? index : dependencies.size(), builder); return (A)this;
  }
  public A setToDependencies(java.lang.Integer index,io.dekorate.helm.config.HelmDependency item) {
    if (this.dependencies == null) {this.dependencies = new java.util.ArrayList<io.dekorate.helm.config.HelmDependencyBuilder>();}
    io.dekorate.helm.config.HelmDependencyBuilder builder = new io.dekorate.helm.config.HelmDependencyBuilder(item);
    if (index < 0 || index >= _visitables.get("dependencies").size()) { _visitables.get("dependencies").add(builder); } else { _visitables.get("dependencies").set(index, builder);}
    if (index < 0 || index >= dependencies.size()) { dependencies.add(builder); } else { dependencies.set(index, builder);}
     return (A)this;
  }
  public A addToDependencies(io.dekorate.helm.config.HelmDependency... items) {
    if (this.dependencies == null) {this.dependencies = new java.util.ArrayList<io.dekorate.helm.config.HelmDependencyBuilder>();}
    for (io.dekorate.helm.config.HelmDependency item : items) {io.dekorate.helm.config.HelmDependencyBuilder builder = new io.dekorate.helm.config.HelmDependencyBuilder(item);_visitables.get("dependencies").add(builder);this.dependencies.add(builder);} return (A)this;
  }
  public A addAllToDependencies(java.util.Collection<io.dekorate.helm.config.HelmDependency> items) {
    if (this.dependencies == null) {this.dependencies = new java.util.ArrayList<io.dekorate.helm.config.HelmDependencyBuilder>();}
    for (io.dekorate.helm.config.HelmDependency item : items) {io.dekorate.helm.config.HelmDependencyBuilder builder = new io.dekorate.helm.config.HelmDependencyBuilder(item);_visitables.get("dependencies").add(builder);this.dependencies.add(builder);} return (A)this;
  }
  public A removeFromDependencies(io.dekorate.helm.config.HelmDependency... items) {
    for (io.dekorate.helm.config.HelmDependency item : items) {io.dekorate.helm.config.HelmDependencyBuilder builder = new io.dekorate.helm.config.HelmDependencyBuilder(item);_visitables.get("dependencies").remove(builder);if (this.dependencies != null) {this.dependencies.remove(builder);}} return (A)this;
  }
  public A removeAllFromDependencies(java.util.Collection<io.dekorate.helm.config.HelmDependency> items) {
    for (io.dekorate.helm.config.HelmDependency item : items) {io.dekorate.helm.config.HelmDependencyBuilder builder = new io.dekorate.helm.config.HelmDependencyBuilder(item);_visitables.get("dependencies").remove(builder);if (this.dependencies != null) {this.dependencies.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromDependencies(java.util.function.Predicate<io.dekorate.helm.config.HelmDependencyBuilder> predicate) {
    if (dependencies == null) return (A) this;
    final Iterator<io.dekorate.helm.config.HelmDependencyBuilder> each = dependencies.iterator();
    final List visitables = _visitables.get("dependencies");
    while (each.hasNext()) {
      io.dekorate.helm.config.HelmDependencyBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public java.lang.Boolean hasDependencies() {
    return dependencies != null && !dependencies.isEmpty();
  }
  public A addNewDependency(java.lang.String name,java.lang.String version,java.lang.String repository) {
    return (A)addToDependencies(new HelmDependency(name, version, repository));
  }
  public io.dekorate.helm.config.HelmChartConfigFluent.DependenciesNested<A> addNewDependency() {
    return new io.dekorate.helm.config.HelmChartConfigFluentImpl.DependenciesNestedImpl();
  }
  public io.dekorate.helm.config.HelmChartConfigFluent.DependenciesNested<A> addNewDependencyLike(io.dekorate.helm.config.HelmDependency item) {
    return new io.dekorate.helm.config.HelmChartConfigFluentImpl.DependenciesNestedImpl(-1, item);
  }
  public io.dekorate.helm.config.HelmChartConfigFluent.DependenciesNested<A> setNewDependencyLike(java.lang.Integer index,io.dekorate.helm.config.HelmDependency item) {
    return new io.dekorate.helm.config.HelmChartConfigFluentImpl.DependenciesNestedImpl(index, item);
  }
  public io.dekorate.helm.config.HelmChartConfigFluent.DependenciesNested<A> editDependency(java.lang.Integer index) {
    if (dependencies.size() <= index) throw new RuntimeException("Can't edit dependencies. Index exceeds size.");
    return setNewDependencyLike(index, buildDependency(index));
  }
  public io.dekorate.helm.config.HelmChartConfigFluent.DependenciesNested<A> editFirstDependency() {
    if (dependencies.size() == 0) throw new RuntimeException("Can't edit first dependencies. The list is empty.");
    return setNewDependencyLike(0, buildDependency(0));
  }
  public io.dekorate.helm.config.HelmChartConfigFluent.DependenciesNested<A> editLastDependency() {
    int index = dependencies.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last dependencies. The list is empty.");
    return setNewDependencyLike(index, buildDependency(index));
  }
  public io.dekorate.helm.config.HelmChartConfigFluent.DependenciesNested<A> editMatchingDependency(java.util.function.Predicate<io.dekorate.helm.config.HelmDependencyBuilder> predicate) {
    int index = -1;
    for (int i=0;i<dependencies.size();i++) { 
    if (predicate.test(dependencies.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching dependencies. No match found.");
    return setNewDependencyLike(index, buildDependency(index));
  }
  public A withValues(io.dekorate.helm.config.ValueReference... values) {
    if (this.values != null) {this.values.clear();}
    if (values != null) {for (io.dekorate.helm.config.ValueReference item :values){ this.addToValues(item);}} return (A) this;
  }
  
  /**
   * This method has been deprecated, please use method buildValues instead.
   */
  @java.lang.Deprecated
  public io.dekorate.helm.config.ValueReference[] getValues() {
    int size = values != null ? values.size() : 0;
io.dekorate.helm.config.ValueReference[] result = new io.dekorate.helm.config.ValueReference[size];
if (size == 0) {
   return result;
}
int index = 0;
for (io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.dekorate.helm.config.ValueReference,?> builder : values) {
    result[index++]=builder.build();
}
return result;

  }
  public io.dekorate.helm.config.ValueReference[] buildValues() {
    int size = values != null ? values.size() : 0;
io.dekorate.helm.config.ValueReference[] result = new io.dekorate.helm.config.ValueReference[size];
if (size == 0) {
   return result;
}
int index = 0;
for (io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.dekorate.helm.config.ValueReference,?> builder : values) {
    result[index++]=builder.build();
}
return result;

  }
  public io.dekorate.helm.config.ValueReference buildValue(java.lang.Integer index) {
    return this.values.get(index).build();
  }
  public io.dekorate.helm.config.ValueReference buildFirstValue() {
    return this.values.get(0).build();
  }
  public io.dekorate.helm.config.ValueReference buildLastValue() {
    return this.values.get(values.size() - 1).build();
  }
  public io.dekorate.helm.config.ValueReference buildMatchingValue(java.util.function.Predicate<io.dekorate.helm.config.ValueReferenceBuilder> predicate) {
    for (io.dekorate.helm.config.ValueReferenceBuilder item: values) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingValue(java.util.function.Predicate<io.dekorate.helm.config.ValueReferenceBuilder> predicate) {
    for (io.dekorate.helm.config.ValueReferenceBuilder item: values) { if(predicate.test(item)){ return true;} } return false;
  }
  public A addToValues(java.lang.Integer index,io.dekorate.helm.config.ValueReference item) {
    if (this.values == null) {this.values = new java.util.ArrayList<io.dekorate.helm.config.ValueReferenceBuilder>();}
    io.dekorate.helm.config.ValueReferenceBuilder builder = new io.dekorate.helm.config.ValueReferenceBuilder(item);_visitables.get("values").add(index >= 0 ? index : _visitables.get("values").size(), builder);this.values.add(index >= 0 ? index : values.size(), builder); return (A)this;
  }
  public A setToValues(java.lang.Integer index,io.dekorate.helm.config.ValueReference item) {
    if (this.values == null) {this.values = new java.util.ArrayList<io.dekorate.helm.config.ValueReferenceBuilder>();}
    io.dekorate.helm.config.ValueReferenceBuilder builder = new io.dekorate.helm.config.ValueReferenceBuilder(item);
    if (index < 0 || index >= _visitables.get("values").size()) { _visitables.get("values").add(builder); } else { _visitables.get("values").set(index, builder);}
    if (index < 0 || index >= values.size()) { values.add(builder); } else { values.set(index, builder);}
     return (A)this;
  }
  public A addToValues(io.dekorate.helm.config.ValueReference... items) {
    if (this.values == null) {this.values = new java.util.ArrayList<io.dekorate.helm.config.ValueReferenceBuilder>();}
    for (io.dekorate.helm.config.ValueReference item : items) {io.dekorate.helm.config.ValueReferenceBuilder builder = new io.dekorate.helm.config.ValueReferenceBuilder(item);_visitables.get("values").add(builder);this.values.add(builder);} return (A)this;
  }
  public A addAllToValues(java.util.Collection<io.dekorate.helm.config.ValueReference> items) {
    if (this.values == null) {this.values = new java.util.ArrayList<io.dekorate.helm.config.ValueReferenceBuilder>();}
    for (io.dekorate.helm.config.ValueReference item : items) {io.dekorate.helm.config.ValueReferenceBuilder builder = new io.dekorate.helm.config.ValueReferenceBuilder(item);_visitables.get("values").add(builder);this.values.add(builder);} return (A)this;
  }
  public A removeFromValues(io.dekorate.helm.config.ValueReference... items) {
    for (io.dekorate.helm.config.ValueReference item : items) {io.dekorate.helm.config.ValueReferenceBuilder builder = new io.dekorate.helm.config.ValueReferenceBuilder(item);_visitables.get("values").remove(builder);if (this.values != null) {this.values.remove(builder);}} return (A)this;
  }
  public A removeAllFromValues(java.util.Collection<io.dekorate.helm.config.ValueReference> items) {
    for (io.dekorate.helm.config.ValueReference item : items) {io.dekorate.helm.config.ValueReferenceBuilder builder = new io.dekorate.helm.config.ValueReferenceBuilder(item);_visitables.get("values").remove(builder);if (this.values != null) {this.values.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromValues(java.util.function.Predicate<io.dekorate.helm.config.ValueReferenceBuilder> predicate) {
    if (values == null) return (A) this;
    final Iterator<io.dekorate.helm.config.ValueReferenceBuilder> each = values.iterator();
    final List visitables = _visitables.get("values");
    while (each.hasNext()) {
      io.dekorate.helm.config.ValueReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public java.lang.Boolean hasValues() {
    return values != null && !values.isEmpty();
  }
  public A addNewValue(java.lang.String property,java.lang.String[] jsonPaths,java.lang.String profile,java.lang.String value) {
    return (A)addToValues(new ValueReference(property, jsonPaths, profile, value));
  }
  public io.dekorate.helm.config.HelmChartConfigFluent.ValuesNested<A> addNewValue() {
    return new io.dekorate.helm.config.HelmChartConfigFluentImpl.ValuesNestedImpl();
  }
  public io.dekorate.helm.config.HelmChartConfigFluent.ValuesNested<A> addNewValueLike(io.dekorate.helm.config.ValueReference item) {
    return new io.dekorate.helm.config.HelmChartConfigFluentImpl.ValuesNestedImpl(-1, item);
  }
  public io.dekorate.helm.config.HelmChartConfigFluent.ValuesNested<A> setNewValueLike(java.lang.Integer index,io.dekorate.helm.config.ValueReference item) {
    return new io.dekorate.helm.config.HelmChartConfigFluentImpl.ValuesNestedImpl(index, item);
  }
  public io.dekorate.helm.config.HelmChartConfigFluent.ValuesNested<A> editValue(java.lang.Integer index) {
    if (values.size() <= index) throw new RuntimeException("Can't edit values. Index exceeds size.");
    return setNewValueLike(index, buildValue(index));
  }
  public io.dekorate.helm.config.HelmChartConfigFluent.ValuesNested<A> editFirstValue() {
    if (values.size() == 0) throw new RuntimeException("Can't edit first values. The list is empty.");
    return setNewValueLike(0, buildValue(0));
  }
  public io.dekorate.helm.config.HelmChartConfigFluent.ValuesNested<A> editLastValue() {
    int index = values.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last values. The list is empty.");
    return setNewValueLike(index, buildValue(index));
  }
  public io.dekorate.helm.config.HelmChartConfigFluent.ValuesNested<A> editMatchingValue(java.util.function.Predicate<io.dekorate.helm.config.ValueReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<values.size();i++) { 
    if (predicate.test(values.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching values. No match found.");
    return setNewValueLike(index, buildValue(index));
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HelmChartConfigFluentImpl that = (HelmChartConfigFluentImpl) o;
    if (enabled != null ? !enabled.equals(that.enabled) :that.enabled != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (extension != null ? !extension.equals(that.extension) :that.extension != null) return false;
    if (description != null ? !description.equals(that.description) :that.description != null) return false;
    if (version != null ? !version.equals(that.version) :that.version != null) return false;
    if (icon != null ? !icon.equals(that.icon) :that.icon != null) return false;
    if (home != null ? !home.equals(that.home) :that.home != null) return false;
    if (keywords != null ? !keywords.equals(that.keywords) :that.keywords != null) return false;
    if (sources != null ? !sources.equals(that.sources) :that.sources != null) return false;
    if (maintainers != null ? !maintainers.equals(that.maintainers) :that.maintainers != null) return false;
    if (dependencies != null ? !dependencies.equals(that.dependencies) :that.dependencies != null) return false;
    if (values != null ? !values.equals(that.values) :that.values != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(enabled,  name,  extension,  description,  version,  icon,  home,  keywords,  sources,  maintainers,  dependencies,  values,  super.hashCode());
  }
  
 /**
  * Generated
  */
public class MaintainersNestedImpl<N> extends io.dekorate.helm.config.MaintainerFluentImpl<io.dekorate.helm.config.HelmChartConfigFluent.MaintainersNested<N>> implements io.dekorate.helm.config.HelmChartConfigFluent.MaintainersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    MaintainersNestedImpl(java.lang.Integer index,io.dekorate.helm.config.Maintainer item) {
      this.index = index;
      this.builder = new io.dekorate.helm.config.MaintainerBuilder(this, item);
    }
    MaintainersNestedImpl() {
      this.index = -1;
      this.builder = new io.dekorate.helm.config.MaintainerBuilder(this);
    }
    io.dekorate.helm.config.MaintainerBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) HelmChartConfigFluentImpl.this.setToMaintainers(index,builder.build());
    }
    public N endMaintainer() {
      return and();
    }
    
  }
  
 /**
  * Generated
  */
public class DependenciesNestedImpl<N> extends io.dekorate.helm.config.HelmDependencyFluentImpl<io.dekorate.helm.config.HelmChartConfigFluent.DependenciesNested<N>> implements io.dekorate.helm.config.HelmChartConfigFluent.DependenciesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    DependenciesNestedImpl(java.lang.Integer index,io.dekorate.helm.config.HelmDependency item) {
      this.index = index;
      this.builder = new io.dekorate.helm.config.HelmDependencyBuilder(this, item);
    }
    DependenciesNestedImpl() {
      this.index = -1;
      this.builder = new io.dekorate.helm.config.HelmDependencyBuilder(this);
    }
    io.dekorate.helm.config.HelmDependencyBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) HelmChartConfigFluentImpl.this.setToDependencies(index,builder.build());
    }
    public N endDependency() {
      return and();
    }
    
  }
  
 /**
  * Generated
  */
public class ValuesNestedImpl<N> extends io.dekorate.helm.config.ValueReferenceFluentImpl<io.dekorate.helm.config.HelmChartConfigFluent.ValuesNested<N>> implements io.dekorate.helm.config.HelmChartConfigFluent.ValuesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ValuesNestedImpl(java.lang.Integer index,io.dekorate.helm.config.ValueReference item) {
      this.index = index;
      this.builder = new io.dekorate.helm.config.ValueReferenceBuilder(this, item);
    }
    ValuesNestedImpl() {
      this.index = -1;
      this.builder = new io.dekorate.helm.config.ValueReferenceBuilder(this);
    }
    io.dekorate.helm.config.ValueReferenceBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) HelmChartConfigFluentImpl.this.setToValues(index,builder.build());
    }
    public N endValue() {
      return and();
    }
    
  }
  
}