/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.helm.config;

import io.dekorate.helm.config.EditableMaintainer;
import io.dekorate.helm.config.Maintainer;
import io.dekorate.helm.config.MaintainerFluent;
import io.dekorate.helm.config.MaintainerFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Objects;

public class MaintainerBuilder
extends MaintainerFluentImpl<MaintainerBuilder>
implements VisitableBuilder<Maintainer, MaintainerBuilder> {
    MaintainerFluent<?> fluent;
    Boolean validationEnabled;

    public MaintainerBuilder() {
        this(false);
    }

    public MaintainerBuilder(Boolean validationEnabled) {
        this(new Maintainer(), validationEnabled);
    }

    public MaintainerBuilder(MaintainerFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public MaintainerBuilder(MaintainerFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Maintainer(), validationEnabled);
    }

    public MaintainerBuilder(MaintainerFluent<?> fluent, Maintainer instance) {
        this(fluent, instance, false);
    }

    public MaintainerBuilder(MaintainerFluent<?> fluent, Maintainer instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withEmail(instance.getEmail());
        fluent.withUrl(instance.getUrl());
        this.validationEnabled = validationEnabled;
    }

    public MaintainerBuilder(Maintainer instance) {
        this(instance, (Boolean)false);
    }

    public MaintainerBuilder(Maintainer instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withEmail(instance.getEmail());
        this.withUrl(instance.getUrl());
        this.validationEnabled = validationEnabled;
    }

    public EditableMaintainer build() {
        EditableMaintainer buildable = new EditableMaintainer(this.fluent.getName(), this.fluent.getEmail(), this.fluent.getUrl());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MaintainerBuilder that = (MaintainerBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

