/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.helm.config;

import io.dekorate.helm.config.HelmChartConfigBuilder;
import io.dekorate.helm.config.HelmDependency;
import io.dekorate.helm.config.Maintainer;
import io.dekorate.helm.config.ValueReference;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.project.Project;
import java.util.Map;
import java.util.Objects;

public class HelmChartConfig
extends Configuration {
    private Boolean enabled;
    private String name;
    private String apiVersion;
    private String valuesRootAlias;
    private String description;
    private String version;
    private String icon;
    private String home;
    private String[] keywords = new String[0];
    private String[] sources = new String[0];
    private Boolean createTarFile;
    private String extension;
    private String notes;
    private String inputFolder;
    private String outputFolder;
    private Maintainer[] maintainers = new Maintainer[0];
    private HelmDependency[] dependencies = new HelmDependency[0];
    private ValueReference[] values = new ValueReference[0];

    public HelmChartConfig() {
    }

    public HelmChartConfig(Project project, Map<ConfigKey, Object> attributes, Boolean enabled, String name, String apiVersion, String valuesRootAlias, String description, String version, String icon, String home, String[] keywords, String[] sources, Boolean createTarFile, String extension, String notes, String inputFolder, String outputFolder, Maintainer[] maintainers, HelmDependency[] dependencies, ValueReference[] values) {
        super(project, attributes);
        this.enabled = enabled;
        this.name = name;
        this.apiVersion = apiVersion;
        this.valuesRootAlias = valuesRootAlias;
        this.description = description;
        this.version = version;
        this.icon = icon;
        this.home = home;
        this.keywords = keywords != null ? keywords : new String[]{};
        this.sources = sources != null ? sources : new String[]{};
        this.createTarFile = createTarFile;
        this.extension = extension;
        this.notes = notes;
        this.inputFolder = inputFolder;
        this.outputFolder = outputFolder;
        this.maintainers = maintainers != null ? maintainers : new Maintainer[]{};
        this.dependencies = dependencies != null ? dependencies : new HelmDependency[]{};
        this.values = values != null ? values : new ValueReference[]{};
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public boolean isEnabled() {
        return this.enabled != null && this.enabled != false;
    }

    public String getName() {
        return this.name;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getValuesRootAlias() {
        return this.valuesRootAlias;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVersion() {
        return this.version;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getHome() {
        return this.home;
    }

    public String[] getKeywords() {
        return this.keywords;
    }

    public String[] getSources() {
        return this.sources;
    }

    public Boolean getCreateTarFile() {
        return this.createTarFile;
    }

    public boolean isCreateTarFile() {
        return this.createTarFile != null && this.createTarFile != false;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getNotes() {
        return this.notes;
    }

    public String getInputFolder() {
        return this.inputFolder;
    }

    public String getOutputFolder() {
        return this.outputFolder;
    }

    public Maintainer[] getMaintainers() {
        return this.maintainers;
    }

    public HelmDependency[] getDependencies() {
        return this.dependencies;
    }

    public ValueReference[] getValues() {
        return this.values;
    }

    public static HelmChartConfigBuilder newHelmChartConfigBuilder() {
        return new HelmChartConfigBuilder();
    }

    public static HelmChartConfigBuilder newHelmChartConfigBuilderFromDefaults() {
        return (HelmChartConfigBuilder)((HelmChartConfigBuilder)((HelmChartConfigBuilder)((HelmChartConfigBuilder)((HelmChartConfigBuilder)((HelmChartConfigBuilder)((HelmChartConfigBuilder)((HelmChartConfigBuilder)new HelmChartConfigBuilder().withEnabled(true)).withApiVersion("v2")).withValuesRootAlias("app")).withCreateTarFile(false)).withExtension("tar.gz")).withNotes("/NOTES.template.txt")).withInputFolder("helm")).withOutputFolder("helm");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HelmChartConfig that = (HelmChartConfig)((Object)o);
        if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.valuesRootAlias != null ? !this.valuesRootAlias.equals(that.valuesRootAlias) : that.valuesRootAlias != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        if (this.icon != null ? !this.icon.equals(that.icon) : that.icon != null) {
            return false;
        }
        if (this.home != null ? !this.home.equals(that.home) : that.home != null) {
            return false;
        }
        if (this.keywords != null ? !this.keywords.equals(that.keywords) : that.keywords != null) {
            return false;
        }
        if (this.sources != null ? !this.sources.equals(that.sources) : that.sources != null) {
            return false;
        }
        if (this.createTarFile != null ? !this.createTarFile.equals(that.createTarFile) : that.createTarFile != null) {
            return false;
        }
        if (this.extension != null ? !this.extension.equals(that.extension) : that.extension != null) {
            return false;
        }
        if (this.notes != null ? !this.notes.equals(that.notes) : that.notes != null) {
            return false;
        }
        if (this.inputFolder != null ? !this.inputFolder.equals(that.inputFolder) : that.inputFolder != null) {
            return false;
        }
        if (this.outputFolder != null ? !this.outputFolder.equals(that.outputFolder) : that.outputFolder != null) {
            return false;
        }
        if (this.maintainers != null ? !this.maintainers.equals(that.maintainers) : that.maintainers != null) {
            return false;
        }
        if (this.dependencies != null ? !this.dependencies.equals(that.dependencies) : that.dependencies != null) {
            return false;
        }
        return !(this.values != null ? !this.values.equals(that.values) : that.values != null);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.name, this.apiVersion, this.valuesRootAlias, this.description, this.version, this.icon, this.home, this.keywords, this.sources, this.createTarFile, this.extension, this.notes, this.inputFolder, this.outputFolder, this.maintainers, this.dependencies, this.values, super.hashCode());
    }
}

