package io.dekorate.helm.adapter;

import java.util.stream.Collectors;
import io.dekorate.helm.config.HelmChartConfigBuilder;
import java.lang.String;
import io.dekorate.helm.config.HelmDependency;
import io.dekorate.helm.config.Maintainer;
import io.dekorate.project.Project;
import io.dekorate.project.BuildInfo;
import io.dekorate.helm.annotation.HelmChart;
import java.lang.Object;
import java.util.List;
import io.dekorate.project.ScmInfo;
import java.lang.Boolean;
import java.util.Arrays;
import java.util.Map;
import io.dekorate.helm.config.HelmChartConfig;
import io.dekorate.helm.config.ValueReference;

 /**
  * Generated
  */
public class HelmChartConfigAdapter{
  public static HelmChartConfig adapt(HelmChart instance) {
    return newBuilder(instance).build();
  }
  public static HelmChartConfigBuilder newBuilder(io.dekorate.helm.annotation.HelmChart instance) {
    return new HelmChartConfigBuilder(new io.dekorate.helm.config.HelmChartConfig(null,
            null,
            instance.enabled(),
            instance.name(),
            instance.valuesRootAlias(),
            instance.description(),
            instance.version(),
            instance.icon(),
            instance.home(),
            instance.keywords(),
            instance.sources(),
            instance.createTarFile(),
            instance.extension(),
            instance.notes(),
            Arrays.asList(instance.maintainers()).stream().map(i ->new Maintainer(i.name(),
            i.email(),
            i.url())).collect(Collectors.toList()).toArray(new io.dekorate.helm.config.Maintainer[0]),
            Arrays.asList(instance.dependencies()).stream().map(i ->new HelmDependency(i.name(),
            i.alias(),
            i.version(),
            i.repository())).collect(Collectors.toList()).toArray(new io.dekorate.helm.config.HelmDependency[0]),
            Arrays.asList(instance.values()).stream().map(i ->new ValueReference(i.property(),
            i.paths(),
            i.profile(),
            i.value())).collect(Collectors.toList()).toArray(new io.dekorate.helm.config.ValueReference[0])));
  }
  public static io.dekorate.helm.config.HelmChartConfig adapt(Map map) {
    return new io.dekorate.helm.config.HelmChartConfig(
null,
null,
               (Boolean)(map instanceof Map ? ((Map)map).getOrDefault("enabled", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("name", null) : null),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("valuesRootAlias", null) : null),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("description", null) : null),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("version", null) : null),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("icon", null) : null),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("home", null) : null),
map instanceof Map ? toStringArray(((Map)map).get("keywords")) : toStringArray(map),
map instanceof Map ? toStringArray(((Map)map).get("sources")) : toStringArray(map),
               (java.lang.Boolean)(map instanceof Map ? ((Map)map).getOrDefault("createTarFile", null) : null),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("extension", null) : null),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("notes", null) : null),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("maintainers" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.helm.config.Maintainer(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("email", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("url", null) : null))).toArray(size-> new io.dekorate.helm.config.Maintainer[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("dependencies" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.helm.config.HelmDependency(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("alias", "") : ""),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("version", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("repository", null) : null))).toArray(size-> new io.dekorate.helm.config.HelmDependency[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("values" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.helm.config.ValueReference(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("property", null) : null),
i instanceof Map ? toStringArray(((Map)i).get("paths")) : toStringArray(i),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("profile", "") : ""),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("value", "") : ""))).toArray(size-> new io.dekorate.helm.config.ValueReference[size]));
  }
  public static io.dekorate.helm.config.HelmChartConfigBuilder newBuilder(java.util.Map map) {
    return new HelmChartConfigBuilder(new io.dekorate.helm.config.HelmChartConfig(
null,
null,
               (java.lang.Boolean)(map instanceof Map ? ((Map)map).getOrDefault("enabled", null) : null),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("name", null) : null),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("valuesRootAlias", null) : null),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("description", null) : null),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("version", null) : null),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("icon", null) : null),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("home", null) : null),
map instanceof Map ? toStringArray(((Map)map).get("keywords")) : toStringArray(map),
map instanceof Map ? toStringArray(((Map)map).get("sources")) : toStringArray(map),
               (java.lang.Boolean)(map instanceof Map ? ((Map)map).getOrDefault("createTarFile", null) : null),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("extension", null) : null),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("notes", null) : null),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("maintainers" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.helm.config.Maintainer(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("email", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("url", null) : null))).toArray(size-> new io.dekorate.helm.config.Maintainer[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("dependencies" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.helm.config.HelmDependency(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("alias", "") : ""),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("version", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("repository", null) : null))).toArray(size-> new io.dekorate.helm.config.HelmDependency[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("values" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.helm.config.ValueReference(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("property", null) : null),
i instanceof Map ? toStringArray(((Map)i).get("paths")) : toStringArray(i),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("profile", "") : ""),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("value", "") : ""))).toArray(size-> new io.dekorate.helm.config.ValueReference[size])));
  }
  public static java.lang.String[] toStringArray(Object o) {
            if (o instanceof String[]) {
          return (String[]) o;
        }
        if (o instanceof String) {
          String s =  (String) o;
          return s.split(",[ ]*");
        }
        else if (o instanceof List) {
          List c = (List) o;
          String[] result = new String[c.size()]; 
          for (int i=0; i <= c.size(); i++) {
            result[i] = String.valueOf(c.get(i));
          }
          return result;
        }
        return new String[0];
    

  }
  
}