/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.helm.util;

import io.dekorate.utils.Strings;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;

public class HelmExpressionParser {
    private static final String NO_REPLACEMENT = "no";
    private static final String WILDCARD = "*.";
    private static final String ESCAPE = "'";
    private static final String DOT = ".";
    private final List<Map<Object, Object>> resources;

    public HelmExpressionParser(List<Map<Object, Object>> resources) {
        this.resources = resources;
    }

    public Object readAndSet(String path, String replacement) {
        HashSet<Object> values = new HashSet<Object>();
        for (Map<Object, Object> resource : this.resources) {
            Object value = HelmExpressionParser.readValuesForResource(resource, path, replacement);
            if (value == null) continue;
            values.add(value);
        }
        return HelmExpressionParser.uniqueResult(values, path);
    }

    private static Object readValuesForResource(Map<Object, Object> resource, String path, String replacement) {
        PathProcessor processor;
        String currentPart;
        int nextIndex;
        while (path.indexOf(DOT) == 0) {
            path = path.substring(1);
        }
        if (path.startsWith("(")) {
            nextIndex = path.indexOf(")");
            currentPart = path.substring(1, nextIndex);
            processor = HelmExpressionParser.locateExpressionPathProcessor(currentPart);
        } else if (path.startsWith(ESCAPE)) {
            String nextPart = path.substring(1);
            nextIndex = nextPart.indexOf(ESCAPE);
            currentPart = nextPart.substring(0, nextIndex);
            processor = new PartPathProcessor(currentPart);
        } else if (path.startsWith(WILDCARD)) {
            nextIndex = (path = path.substring(WILDCARD.length())).indexOf(DOT);
            currentPart = HelmExpressionParser.normalize(nextIndex > 0 ? path.substring(0, nextIndex) : path);
            processor = new WildcardPartPathProcessor(currentPart);
        } else {
            nextIndex = path.indexOf(DOT);
            currentPart = HelmExpressionParser.normalize(nextIndex > 0 ? path.substring(0, nextIndex) : path);
            processor = new PartPathProcessor(currentPart);
        }
        Object result = null;
        if (processor.canHandle(resource)) {
            result = processor.handle(resource);
            if (nextIndex >= 0) {
                if (result instanceof Map) {
                    return HelmExpressionParser.readValuesForResource((Map)result, path.substring(nextIndex + 1), replacement);
                }
                if (result instanceof List) {
                    String nextPath = path.substring(nextIndex + 1);
                    HashSet<Object> values = new HashSet<Object>();
                    for (Object inner : (List)result) {
                        Object value;
                        if (!(inner instanceof Map) || (value = HelmExpressionParser.readValuesForResource((Map)inner, nextPath, replacement)) == null) continue;
                        values.add(value);
                    }
                    return HelmExpressionParser.uniqueResult(values, nextPath);
                }
            }
            if (!NO_REPLACEMENT.equals(replacement)) {
                resource.put(currentPart, replacement);
            }
        }
        return result;
    }

    private static Object uniqueResult(Set<Object> set, String path) {
        if (set.size() > 1) {
            throw new IllegalStateException("Several matches for the path: " + path + ". Found: " + set);
        }
        if (set.isEmpty()) {
            return null;
        }
        return set.iterator().next();
    }

    private static PathProcessor locateExpressionPathProcessor(String expression) {
        for (PathExpression type : PathExpression.values()) {
            if (!expression.contains(type.getOperator())) continue;
            return type.getPathProcessor(expression);
        }
        throw new IllegalStateException("Unrecognised expression: " + expression);
    }

    private static String normalize(String text) {
        if (Strings.isNullOrEmpty((String)text)) {
            return text;
        }
        String normalized = text.trim();
        if (normalized.startsWith(ESCAPE)) {
            normalized = normalized.substring(1, normalized.length() - 1);
        }
        return normalized;
    }

    static enum PathExpression {
        AND("&&", AndPathExpression::new),
        OR("||", OrPathExpression::new),
        IS_EQUAL("==", IsEqualPathExpression::new);

        String operator;
        Function<String, PathProcessor> supplier;

        private PathExpression(String operator, Function<String, PathProcessor> supplier) {
            this.operator = operator;
            this.supplier = supplier;
        }

        public String getOperator() {
            return this.operator;
        }

        public PathProcessor getPathProcessor(String condition) {
            return this.supplier.apply(condition);
        }
    }

    static interface PathProcessor {
        public boolean canHandle(Map<Object, Object> var1);

        public Object handle(Map<Object, Object> var1);
    }

    static class IsEqualPathExpression
    implements PathProcessor {
        private final String left;
        private final String right;

        IsEqualPathExpression(String condition) {
            String[] parts = condition.split(PathExpression.IS_EQUAL.getOperator());
            this.left = HelmExpressionParser.normalize(parts[0]);
            this.right = HelmExpressionParser.normalize(parts[1]);
        }

        @Override
        public boolean canHandle(Map<Object, Object> resource) {
            Object value = HelmExpressionParser.readValuesForResource(resource, this.left, HelmExpressionParser.NO_REPLACEMENT);
            return value != null && value instanceof String && Strings.equals((String)((String)value), (String)this.right);
        }

        @Override
        public Object handle(Map<Object, Object> resource) {
            return resource;
        }
    }

    static abstract class CompositeFilterPathExpression
    implements PathProcessor {
        protected final List<PathProcessor> conditions = new ArrayList<PathProcessor>();

        CompositeFilterPathExpression(String operator, String condition) {
            String[] subConditions;
            for (String subCondition : subConditions = condition.split(Pattern.quote(operator))) {
                this.conditions.add(HelmExpressionParser.locateExpressionPathProcessor(subCondition));
            }
        }

        @Override
        public Object handle(Map<Object, Object> resource) {
            return resource;
        }
    }

    static class OrPathExpression
    extends CompositeFilterPathExpression {
        OrPathExpression(String condition) {
            super(PathExpression.OR.getOperator(), condition);
        }

        @Override
        public boolean canHandle(Map<Object, Object> resource) {
            return this.conditions.stream().anyMatch(c -> c.canHandle(resource));
        }
    }

    static class AndPathExpression
    extends CompositeFilterPathExpression {
        AndPathExpression(String condition) {
            super(PathExpression.AND.getOperator(), condition);
        }

        @Override
        public boolean canHandle(Map<Object, Object> resource) {
            return this.conditions.stream().allMatch(c -> c.canHandle(resource));
        }
    }

    static class PartPathProcessor
    implements PathProcessor {
        private final String part;

        PartPathProcessor(String part) {
            this.part = part;
        }

        @Override
        public boolean canHandle(Map<Object, Object> resource) {
            return resource.containsKey(this.part);
        }

        @Override
        public Object handle(Map<Object, Object> resource) {
            return resource.get(this.part);
        }
    }

    static class WildcardPartPathProcessor
    implements PathProcessor {
        private final String part;
        private final List<Object> allFound = new ArrayList<Object>();

        WildcardPartPathProcessor(String part) {
            this.part = part;
        }

        @Override
        public boolean canHandle(Map<Object, Object> resource) {
            Object found = resource.get(this.part);
            if (found != null) {
                if (found instanceof List) {
                    this.allFound.addAll((List)found);
                } else {
                    this.allFound.add(found);
                }
            }
            for (Object child : resource.values()) {
                if (child instanceof Map) {
                    this.canHandle((Map)child);
                    continue;
                }
                if (!(child instanceof List)) continue;
                List items = (List)child;
                for (Object item : items) {
                    if (!(item instanceof Map)) continue;
                    this.canHandle((Map)item);
                }
            }
            return !this.allFound.isEmpty();
        }

        @Override
        public Object handle(Map<Object, Object> resource) {
            return this.allFound;
        }
    }
}

