package io.dekorate.docker.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;

 /**
  * Generated
  */
public class DockerBuildConfigBuilder extends DockerBuildConfigFluent<DockerBuildConfigBuilder> implements VisitableBuilder<DockerBuildConfig,DockerBuildConfigBuilder>{
  public DockerBuildConfigBuilder() {
    this(false);
  }
  public DockerBuildConfigBuilder(Boolean validationEnabled) {
    this(new DockerBuildConfig(), validationEnabled);
  }
  public DockerBuildConfigBuilder(DockerBuildConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public DockerBuildConfigBuilder(DockerBuildConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DockerBuildConfig(), validationEnabled);
  }
  public DockerBuildConfigBuilder(DockerBuildConfigFluent<?> fluent,DockerBuildConfig instance) {
    this(fluent, instance, false);
  }
  public DockerBuildConfigBuilder(DockerBuildConfigFluent<?> fluent,DockerBuildConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DockerBuildConfig());

    if (instance != null) {
      fluent.withProject(instance.getProject());
      fluent.withAttributes(instance.getAttributes());
      fluent.withEnabled(instance.getEnabled());
      fluent.withRegistry(instance.getRegistry());
      fluent.withGroup(instance.getGroup());
      fluent.withName(instance.getName());
      fluent.withVersion(instance.getVersion());
      fluent.withImage(instance.getImage());
      fluent.withDockerFile(instance.getDockerFile());
      fluent.withAutoBuildEnabled(instance.getAutoBuildEnabled());
      fluent.withAutoPushEnabled(instance.getAutoPushEnabled());
      fluent.withAutoLoadEnabled(instance.isAutoLoadEnabled());
      fluent.withAutoDeployEnabled(instance.getAutoDeployEnabled());
      fluent.withRegistry(instance.getRegistry());
      fluent.withGroup(instance.getGroup());
      fluent.withName(instance.getName());
      fluent.withVersion(instance.getVersion());
      fluent.withImage(instance.getImage());
      fluent.withDockerFile(instance.getDockerFile());
      fluent.withAutoBuildEnabled(instance.getAutoBuildEnabled());
      fluent.withAutoPushEnabled(instance.getAutoPushEnabled());
      fluent.withAutoLoadEnabled(instance.isAutoLoadEnabled());
      fluent.withPartOf(instance.getPartOf());
      fluent.withProject(instance.getProject());
      fluent.withAttributes(instance.getAttributes());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DockerBuildConfigBuilder(DockerBuildConfig instance) {
    this(instance,false);
  }
  public DockerBuildConfigBuilder(DockerBuildConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DockerBuildConfig());

    if (instance != null) {
      this.withProject(instance.getProject());
      this.withAttributes(instance.getAttributes());
      this.withEnabled(instance.getEnabled());
      this.withRegistry(instance.getRegistry());
      this.withGroup(instance.getGroup());
      this.withName(instance.getName());
      this.withVersion(instance.getVersion());
      this.withImage(instance.getImage());
      this.withDockerFile(instance.getDockerFile());
      this.withAutoBuildEnabled(instance.getAutoBuildEnabled());
      this.withAutoPushEnabled(instance.getAutoPushEnabled());
      this.withAutoLoadEnabled(instance.isAutoLoadEnabled());
      this.withAutoDeployEnabled(instance.getAutoDeployEnabled());
      this.withRegistry(instance.getRegistry());
      this.withGroup(instance.getGroup());
      this.withName(instance.getName());
      this.withVersion(instance.getVersion());
      this.withImage(instance.getImage());
      this.withDockerFile(instance.getDockerFile());
      this.withAutoBuildEnabled(instance.getAutoBuildEnabled());
      this.withAutoPushEnabled(instance.getAutoPushEnabled());
      this.withAutoLoadEnabled(instance.isAutoLoadEnabled());
      this.withPartOf(instance.getPartOf());
      this.withProject(instance.getProject());
      this.withAttributes(instance.getAttributes());
    }
    this.validationEnabled = validationEnabled; 
  }
  DockerBuildConfigFluent<?> fluent;
  Boolean validationEnabled;
  public EditableDockerBuildConfig build() {
    EditableDockerBuildConfig buildable = new EditableDockerBuildConfig(fluent.buildProject(),fluent.getAttributes(),fluent.getEnabled(),fluent.getRegistry(),fluent.getGroup(),fluent.getName(),fluent.getVersion(),fluent.getImage(),fluent.getDockerFile(),fluent.getAutoBuildEnabled(),fluent.getAutoPushEnabled(),fluent.getAutoLoadEnabled(),fluent.getAutoDeployEnabled());
    buildable.setPartOf(fluent.getPartOf());
    return buildable;
  }
  
}