package io.dekorate.docker.config;

import io.dekorate.kubernetes.config.ImageConfigurationFluentImpl;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class DockerBuildConfigFluentImpl<A extends DockerBuildConfigFluent<A>> extends ImageConfigurationFluentImpl<A> implements DockerBuildConfigFluent<A> {

    private Boolean enabled;
    private Boolean autoDeployEnabled;

    public DockerBuildConfigFluentImpl() {
    }

    public DockerBuildConfigFluentImpl(DockerBuildConfig instance) {
        this.withProject(instance.getProject()); 
        this.withAttributes(instance.getAttributes()); 
        this.withRegistry(instance.getRegistry()); 
        this.withGroup(instance.getGroup()); 
        this.withName(instance.getName()); 
        this.withVersion(instance.getVersion()); 
        this.withImage(instance.getImage()); 
        this.withDockerFile(instance.getDockerFile()); 
        this.withAutoBuildEnabled(instance.getAutoBuildEnabled()); 
        this.withAutoPushEnabled(instance.getAutoPushEnabled()); 
        this.withEnabled(instance.getEnabled()); 
        this.withAutoDeployEnabled(instance.getAutoDeployEnabled()); 
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled=enabled; return (A) this;
    }

    public Boolean hasEnabled() {
        return this.enabled != null;
    }

    public A withNewEnabled(String arg1) {
        return (A)withEnabled(new Boolean(arg1));
    }

    public A withNewEnabled(boolean arg1) {
        return (A)withEnabled(new Boolean(arg1));
    }

    public Boolean getAutoDeployEnabled() {
        return this.autoDeployEnabled;
    }

    public A withAutoDeployEnabled(Boolean autoDeployEnabled) {
        this.autoDeployEnabled=autoDeployEnabled; return (A) this;
    }

    public Boolean hasAutoDeployEnabled() {
        return this.autoDeployEnabled != null;
    }

    public A withNewAutoDeployEnabled(String arg1) {
        return (A)withAutoDeployEnabled(new Boolean(arg1));
    }

    public A withNewAutoDeployEnabled(boolean arg1) {
        return (A)withAutoDeployEnabled(new Boolean(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        DockerBuildConfigFluentImpl that = (DockerBuildConfigFluentImpl) o;
        if (enabled != null ? !enabled.equals(that.enabled) :that.enabled != null) return false;
        if (autoDeployEnabled != null ? !autoDeployEnabled.equals(that.autoDeployEnabled) :that.autoDeployEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(enabled,  autoDeployEnabled,  super.hashCode());
    }

}
