/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.docker.generator;

import io.dekorate.Generator;
import io.dekorate.Session;
import io.dekorate.WithProject;
import io.dekorate.WithSession;
import io.dekorate.config.AnnotationConfiguration;
import io.dekorate.config.ConfigurationSupplier;
import io.dekorate.config.PropertyConfiguration;
import io.dekorate.docker.adapter.DockerBuildConfigAdapter;
import io.dekorate.docker.config.DockerBuildConfig;
import io.dekorate.docker.config.DockerBuildConfigBuilder;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.kubernetes.configurator.ApplyBuildToImageConfiguration;
import io.dekorate.project.ApplyProjectInfo;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitor;
import java.util.Map;

public interface DockerBuildGenerator
extends Generator,
WithSession,
WithProject {
    default public String getKey() {
        return "docker";
    }

    default public Class<? extends Configuration> getConfigType() {
        return DockerBuildConfig.class;
    }

    default public void addAnnotationConfiguration(Map map) {
        this.on((ConfigurationSupplier<DockerBuildConfig>)new AnnotationConfiguration((VisitableBuilder)((DockerBuildConfigBuilder)DockerBuildConfigAdapter.newBuilder(this.propertiesMap(map, DockerBuildConfig.class)).accept(new Visitor[]{new ApplyProjectInfo(this.getProject())})).accept(new Visitor[]{new ApplyBuildToImageConfiguration()})));
    }

    default public void addPropertyConfiguration(Map map) {
        this.on((ConfigurationSupplier<DockerBuildConfig>)new PropertyConfiguration((VisitableBuilder)((DockerBuildConfigBuilder)DockerBuildConfigAdapter.newBuilder(this.propertiesMap(map, DockerBuildConfig.class)).accept(new Visitor[]{new ApplyProjectInfo(this.getProject())})).accept(new Visitor[]{new ApplyBuildToImageConfiguration()})));
    }

    default public void on(ConfigurationSupplier<DockerBuildConfig> config) {
        Session session = this.getSession();
        session.configurators().add(config);
    }
}

