package io.dekorate.docker.config;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import io.dekorate.kubernetes.config.ApplicationConfigurationFluentImpl;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class DockerBuildConfigFluentImpl<A extends DockerBuildConfigFluent<A>> extends ApplicationConfigurationFluentImpl<A> implements DockerBuildConfigFluent<A>{

    private String dockerFile = "Dockerfile";
    private String registry = "";
    private boolean autoPushEnabled = false;
    private boolean autoBuildEnabled = false;
    private boolean autoDeployEnabled = false;

    public DockerBuildConfigFluentImpl(){
    }
    public DockerBuildConfigFluentImpl(DockerBuildConfig instance){
            this.withProject(instance.getProject()); 
            this.withAttributes(instance.getAttributes()); 
            this.withGroup(instance.getGroup()); 
            this.withName(instance.getName()); 
            this.withVersion(instance.getVersion()); 
            this.withDockerFile(instance.getDockerFile()); 
            this.withRegistry(instance.getRegistry()); 
            this.withAutoPushEnabled(instance.isAutoPushEnabled()); 
            this.withAutoBuildEnabled(instance.isAutoBuildEnabled()); 
            this.withAutoDeployEnabled(instance.isAutoDeployEnabled()); 
    }

    public String getDockerFile(){
            return this.dockerFile;
    }

    public A withDockerFile(String dockerFile){
            this.dockerFile=dockerFile; return (A) this;
    }

    public Boolean hasDockerFile(){
            return this.dockerFile != null;
    }

    public A withNewDockerFile(String arg1){
            return (A)withDockerFile(new String(arg1));
    }

    public A withNewDockerFile(StringBuilder arg1){
            return (A)withDockerFile(new String(arg1));
    }

    public A withNewDockerFile(StringBuffer arg1){
            return (A)withDockerFile(new String(arg1));
    }

    public String getRegistry(){
            return this.registry;
    }

    public A withRegistry(String registry){
            this.registry=registry; return (A) this;
    }

    public Boolean hasRegistry(){
            return this.registry != null;
    }

    public A withNewRegistry(String arg1){
            return (A)withRegistry(new String(arg1));
    }

    public A withNewRegistry(StringBuilder arg1){
            return (A)withRegistry(new String(arg1));
    }

    public A withNewRegistry(StringBuffer arg1){
            return (A)withRegistry(new String(arg1));
    }

    public boolean isAutoPushEnabled(){
            return this.autoPushEnabled;
    }

    public A withAutoPushEnabled(boolean autoPushEnabled){
            this.autoPushEnabled=autoPushEnabled; return (A) this;
    }

    public Boolean hasAutoPushEnabled(){
            return true;
    }

    public boolean isAutoBuildEnabled(){
            return this.autoBuildEnabled;
    }

    public A withAutoBuildEnabled(boolean autoBuildEnabled){
            this.autoBuildEnabled=autoBuildEnabled; return (A) this;
    }

    public Boolean hasAutoBuildEnabled(){
            return true;
    }

    public boolean isAutoDeployEnabled(){
            return this.autoDeployEnabled;
    }

    public A withAutoDeployEnabled(boolean autoDeployEnabled){
            this.autoDeployEnabled=autoDeployEnabled; return (A) this;
    }

    public Boolean hasAutoDeployEnabled(){
            return true;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DockerBuildConfigFluentImpl that = (DockerBuildConfigFluentImpl) o;
            if (dockerFile != null ? !dockerFile.equals(that.dockerFile) :that.dockerFile != null) return false;
            if (registry != null ? !registry.equals(that.registry) :that.registry != null) return false;
            if (autoPushEnabled != that.autoPushEnabled) return false;
            if (autoBuildEnabled != that.autoBuildEnabled) return false;
            if (autoDeployEnabled != that.autoDeployEnabled) return false;
            return true;
    }




}
