package io.dekorate.docker.config;

import io.dekorate.kubernetes.config.ApplicationConfigurationFluent;
import io.dekorate.project.Project;
import java.lang.StringBuffer;
import io.dekorate.kubernetes.config.ConfigKey;
import java.lang.StringBuilder;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;

public interface DockerBuildConfigFluent<A extends DockerBuildConfigFluent<A>> extends ApplicationConfigurationFluent<A>{


    public String getDockerFile();
    public A withDockerFile(String dockerFile);
    public Boolean hasDockerFile();
    public A withNewDockerFile(String arg1);
    public A withNewDockerFile(StringBuilder arg1);
    public A withNewDockerFile(StringBuffer arg1);
    public String getRegistry();
    public A withRegistry(String registry);
    public Boolean hasRegistry();
    public A withNewRegistry(String arg1);
    public A withNewRegistry(StringBuilder arg1);
    public A withNewRegistry(StringBuffer arg1);
    public boolean isAutoPushEnabled();
    public A withAutoPushEnabled(boolean autoPushEnabled);
    public Boolean hasAutoPushEnabled();
    public boolean isAutoBuildEnabled();
    public A withAutoBuildEnabled(boolean autoBuildEnabled);
    public Boolean hasAutoBuildEnabled();
    public boolean isAutoDeployEnabled();
    public A withAutoDeployEnabled(boolean autoDeployEnabled);
    public Boolean hasAutoDeployEnabled();



}
