package io.dekorate.docker.config;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DockerBuildConfigBuilder extends DockerBuildConfigFluentImpl<DockerBuildConfigBuilder> implements VisitableBuilder<DockerBuildConfig,DockerBuildConfigBuilder>{

    DockerBuildConfigFluent<?> fluent;
    Boolean validationEnabled;

    public DockerBuildConfigBuilder(){
            this(true);
    }
    public DockerBuildConfigBuilder(Boolean validationEnabled){
            this(new DockerBuildConfig(), validationEnabled);
    }
    public DockerBuildConfigBuilder(DockerBuildConfigFluent<?> fluent){
            this(fluent, true);
    }
    public DockerBuildConfigBuilder(DockerBuildConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new DockerBuildConfig(), validationEnabled);
    }
    public DockerBuildConfigBuilder(DockerBuildConfigFluent<?> fluent,DockerBuildConfig instance){
            this(fluent, instance, true);
    }
    public DockerBuildConfigBuilder(DockerBuildConfigFluent<?> fluent,DockerBuildConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withProject(instance.getProject()); 
            fluent.withAttributes(instance.getAttributes()); 
            fluent.withGroup(instance.getGroup()); 
            fluent.withName(instance.getName()); 
            fluent.withVersion(instance.getVersion()); 
            fluent.withDockerFile(instance.getDockerFile()); 
            fluent.withRegistry(instance.getRegistry()); 
            fluent.withAutoPushEnabled(instance.isAutoPushEnabled()); 
            fluent.withAutoBuildEnabled(instance.isAutoBuildEnabled()); 
            fluent.withAutoDeployEnabled(instance.isAutoDeployEnabled()); 
            this.validationEnabled = validationEnabled; 
    }
    public DockerBuildConfigBuilder(DockerBuildConfig instance){
            this(instance,true);
    }
    public DockerBuildConfigBuilder(DockerBuildConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withProject(instance.getProject()); 
            this.withAttributes(instance.getAttributes()); 
            this.withGroup(instance.getGroup()); 
            this.withName(instance.getName()); 
            this.withVersion(instance.getVersion()); 
            this.withDockerFile(instance.getDockerFile()); 
            this.withRegistry(instance.getRegistry()); 
            this.withAutoPushEnabled(instance.isAutoPushEnabled()); 
            this.withAutoBuildEnabled(instance.isAutoBuildEnabled()); 
            this.withAutoDeployEnabled(instance.isAutoDeployEnabled()); 
            this.validationEnabled = validationEnabled; 
    }

    public EditableDockerBuildConfig build(){
            EditableDockerBuildConfig buildable = new EditableDockerBuildConfig(fluent.getProject(),fluent.getAttributes(),fluent.getGroup(),fluent.getName(),fluent.getVersion(),fluent.getDockerFile(),fluent.getRegistry(),fluent.isAutoPushEnabled(),fluent.isAutoBuildEnabled(),fluent.isAutoDeployEnabled());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DockerBuildConfigBuilder that = (DockerBuildConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
