package io.dekorate.docker.config;

import io.dekorate.project.Project;
import io.dekorate.kubernetes.config.ConfigKey;
import java.lang.Object;
import java.lang.String;
import io.dekorate.kubernetes.config.ApplicationConfiguration;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

@Buildable(builderPackage = "io.dekorate.deps.kubernetes.api.builder") public class DockerBuildConfig extends ApplicationConfiguration{

    private String dockerFile = "Dockerfile";
    private String registry = "";
    private boolean autoPushEnabled = false;
    private boolean autoBuildEnabled = false;
    private boolean autoDeployEnabled = false;

    public DockerBuildConfig(){
    }
    public DockerBuildConfig(Project project,Map<ConfigKey,Object> attributes,String group,String name,String version,String dockerFile,String registry,boolean autoPushEnabled,boolean autoBuildEnabled,boolean autoDeployEnabled){
            super(project, attributes, group, name, version);
            this.dockerFile = dockerFile != null ? dockerFile : "Dockerfile";
            this.registry = registry != null ? registry : "";
            this.autoPushEnabled = autoPushEnabled;
            this.autoBuildEnabled = autoBuildEnabled;
            this.autoDeployEnabled = autoDeployEnabled;
    }

    public String getDockerFile(){
            return this.dockerFile;
    }

    public String getRegistry(){
            return this.registry;
    }

    public boolean isAutoPushEnabled(){
            return this.autoPushEnabled;
    }

    public boolean isAutoBuildEnabled(){
            return this.autoBuildEnabled;
    }

    public boolean isAutoDeployEnabled(){
            return this.autoDeployEnabled;
    }

    public static DockerBuildConfigBuilder newDockerBuildConfigBuilder(){
            return new io.dekorate.docker.config.DockerBuildConfigBuilder();
    }




}
