/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.docker.buildservice;

import io.dekorate.BuildService;
import io.dekorate.BuildServiceFactory;
import io.dekorate.deps.kubernetes.api.model.HasMetadata;
import io.dekorate.docker.buildservice.DockerBuildService;
import io.dekorate.kubernetes.config.ImageConfiguration;
import io.dekorate.project.Project;
import io.dekorate.utils.Strings;
import java.util.Collection;

public class DockerBuildServiceFactory
implements BuildServiceFactory {
    public boolean isApplicable(Project project, ImageConfiguration config) {
        boolean result = project.getRoot().resolve(Strings.isNotNullOrEmpty((String)config.getDockerFile()) ? config.getDockerFile() : "Dockerfile").toFile().exists();
        return result;
    }

    public BuildService create(Project project, ImageConfiguration config) {
        return new DockerBuildService(project, config);
    }

    public BuildService create(Project project, ImageConfiguration config, Collection<HasMetadata> resources) {
        return new DockerBuildService(project, config);
    }

    public int order() {
        return 10;
    }
}

