package io.dekorate.docker.adapter;

import java.nio.file.Path;
import java.lang.String;
import io.dekorate.docker.annotation.DockerBuild;
import java.util.Comparator;
import io.dekorate.project.Project;
import io.dekorate.docker.config.DockerBuildConfig;
import io.dekorate.project.BuildInfo;
import io.dekorate.docker.config.DockerBuildConfigBuilder;
import java.lang.Object;
import java.util.List;
import io.dekorate.project.ScmInfo;
import java.util.Map;

public class DockerBuildConfigAdapter {


    public static DockerBuildConfig adapt(DockerBuild instance) {
        return newBuilder(instance).build();
    }

    public static DockerBuildConfigBuilder newBuilder(DockerBuild instance) {
        return new DockerBuildConfigBuilder(new io.dekorate.docker.config.DockerBuildConfig(null,
            null,
            instance.registry(),
            instance.group(),
            instance.name(),
            instance.version(),
            instance.image(),
            instance.dockerFile(),
            instance.autoBuildEnabled(),
            instance.autoPushEnabled(),
            instance.enabled(),
            instance.autoDeployEnabled()));
    }

    public static DockerBuildConfig adapt(Map map) {
        return new io.dekorate.docker.config.DockerBuildConfig(
null,
null,
               (String)(map instanceof Map ? ((Map)map).getOrDefault("registry", "") : ""),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("group", "") : ""),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("name", "") : ""),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("version", "") : ""),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("image", "") : ""),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("dockerFile", "Dockerfile") : "Dockerfile"),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("autoBuildEnabled","false") : "false")),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("autoPushEnabled","false") : "false")),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("enabled","true") : "true")),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("autoDeployEnabled","false") : "false")));
    }

    public static DockerBuildConfigBuilder newBuilder(Map map) {
        return new DockerBuildConfigBuilder(new io.dekorate.docker.config.DockerBuildConfig(
null,
null,
               (String)(map instanceof Map ? ((Map)map).getOrDefault("registry", "") : ""),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("group", "") : ""),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("name", "") : ""),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("version", "") : ""),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("image", "") : ""),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("dockerFile", "Dockerfile") : "Dockerfile"),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("autoBuildEnabled","false") : "false")),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("autoPushEnabled","false") : "false")),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("enabled","true") : "true")),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("autoDeployEnabled","false") : "false"))));
    }

    public static String[] toStringArray(Object o) {
                if (o instanceof String[]) {
          return (String[]) o;
        }
        if (o instanceof String) {
          String s =  (String) o;
          return s.split(",[ ]*");
        }
        else if (o instanceof List) {
          List c = (List) o;
          String[] result = new String[c.size()]; 
          for (int i=0; i <= c.size(); i++) {
            result[i] = String.valueOf(c.get(i));
          }
          return result;
        }
        return new String[0];
    

    }

}
