package io.dekorate.docker.config;

import io.dekorate.project.Project;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.ImageConfiguration;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

@Buildable(builderPackage = "io.dekorate.deps.kubernetes.api.builder") public class DockerBuildConfig extends ImageConfiguration {

    private boolean enabled = true;
    private boolean autoDeployEnabled = false;

    public DockerBuildConfig() { 
    }


    public DockerBuildConfig(Project project,Map<ConfigKey,Object> attributes,String registry,String group,String name,String version,String image,String dockerFile,boolean autoBuildEnabled,boolean autoPushEnabled,boolean enabled,boolean autoDeployEnabled) { 
        super(project, attributes, registry, group, name, version, image, dockerFile, autoBuildEnabled, autoPushEnabled);
        this.enabled = enabled;
        this.autoDeployEnabled = autoDeployEnabled;
    }


    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isAutoDeployEnabled() {
        return this.autoDeployEnabled;
    }

    public static DockerBuildConfigBuilder newDockerBuildConfigBuilder() {
        return new io.dekorate.docker.config.DockerBuildConfigBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        DockerBuildConfig that = (DockerBuildConfig) o;
        if (enabled != that.enabled) return false;
        if (autoDeployEnabled != that.autoDeployEnabled) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(enabled,  autoDeployEnabled,  super.hashCode());
    }

}
