package io.dekorate.docker.config;

import io.dekorate.kubernetes.config.ImageConfigurationFluentImpl;
import java.lang.Object;
import java.lang.Boolean;

public class DockerBuildConfigFluentImpl<A extends DockerBuildConfigFluent<A>> extends ImageConfigurationFluentImpl<A> implements DockerBuildConfigFluent<A> {

    private boolean enabled = true;
    private boolean autoDeployEnabled = false;

    public DockerBuildConfigFluentImpl() { 
    }


    public DockerBuildConfigFluentImpl(DockerBuildConfig instance) { 
        this.withProject(instance.getProject()); 
        this.withAttributes(instance.getAttributes()); 
        this.withRegistry(instance.getRegistry()); 
        this.withGroup(instance.getGroup()); 
        this.withName(instance.getName()); 
        this.withVersion(instance.getVersion()); 
        this.withImage(instance.getImage()); 
        this.withDockerFile(instance.getDockerFile()); 
        this.withAutoBuildEnabled(instance.isAutoBuildEnabled()); 
        this.withAutoPushEnabled(instance.isAutoPushEnabled()); 
        this.withEnabled(instance.isEnabled()); 
        this.withAutoDeployEnabled(instance.isAutoDeployEnabled()); 
    }


    public boolean isEnabled() {
        return this.enabled;
    }

    public A withEnabled(boolean enabled) {
        this.enabled=enabled; return (A) this;
    }

    public Boolean hasEnabled() {
        return true;
    }

    public boolean isAutoDeployEnabled() {
        return this.autoDeployEnabled;
    }

    public A withAutoDeployEnabled(boolean autoDeployEnabled) {
        this.autoDeployEnabled=autoDeployEnabled; return (A) this;
    }

    public Boolean hasAutoDeployEnabled() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        DockerBuildConfigFluentImpl that = (DockerBuildConfigFluentImpl) o;
        if (enabled != that.enabled) return false;
        if (autoDeployEnabled != that.autoDeployEnabled) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(enabled,  autoDeployEnabled,  super.hashCode());
    }

}
