package io.dekorate.docker.config;

import io.dekorate.project.Project;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.ImageConfiguration;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

@Buildable(builderPackage = "io.dekorate.deps.kubernetes.api.builder") public class DockerBuildConfig extends ImageConfiguration{

    private boolean autoDeployEnabled = false;

    public DockerBuildConfig(){
    }
    public DockerBuildConfig(Project project,Map<ConfigKey,Object> attributes,String group,String name,String version,String registry,String dockerFile,boolean autoBuildEnabled,boolean autoPushEnabled,boolean autoDeployEnabled){
            super(project, attributes, group, name, version, registry, dockerFile, autoBuildEnabled, autoPushEnabled);
            this.autoDeployEnabled = autoDeployEnabled;
    }

    public boolean isAutoDeployEnabled(){
            return this.autoDeployEnabled;
    }

    public static DockerBuildConfigBuilder newDockerBuildConfigBuilder(){
            return new io.dekorate.docker.config.DockerBuildConfigBuilder();
    }




}
