/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.thorntail;

import io.dekorate.ConfigurationGenerator;
import io.dekorate.Session;
import io.dekorate.WithSession;
import io.dekorate.kubernetes.config.Configurator;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.PortBuilder;
import io.dekorate.kubernetes.configurator.AddPort;
import io.dekorate.kubernetes.configurator.SetPortPath;
import io.dekorate.thorntail.ThorntailConfigHolder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.servlet.annotation.WebServlet;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Path;

public interface ThorntailWebAnnotationGenerator
extends ConfigurationGenerator,
WithSession,
ThorntailConfigHolder {
    default public void add(Element element) {
        final ApplicationPath applicationPath = element.getAnnotation(ApplicationPath.class);
        if (applicationPath != null) {
            HashMap<String, 1> map = new HashMap<String, 1>();
            map.put(ApplicationPath.class.getName(), new HashMap<String, String>(){
                {
                    this.put("value", applicationPath.value());
                }
            });
            this.addAnnotationConfiguration(map);
        }
        if (element.getAnnotation(Path.class) != null) {
            this.addAnnotationConfiguration(Collections.emptyMap());
        }
        if (element.getAnnotation(WebServlet.class) != null) {
            this.addAnnotationConfiguration(Collections.emptyMap());
        }
    }

    default public void addAnnotationConfiguration(Map map) {
        this.addPropertyConfiguration(map);
    }

    default public void addPropertyConfiguration(Map map) {
        Map applicationPath;
        Object o;
        Session session = this.getSession();
        Port port = this.detectHttpPort();
        session.getConfigurationRegistry().add((Configurator)new AddPort(port));
        if (map.containsKey(ApplicationPath.class.getName()) && (o = map.get(ApplicationPath.class.getName())) instanceof Map && (applicationPath = (Map)o) != null && applicationPath.containsKey("value")) {
            String path = String.valueOf(applicationPath.get("value"));
            session.getConfigurationRegistry().add((Configurator)new SetPortPath(port.getName(), path));
        }
    }

    default public Port detectHttpPort() {
        return ((PortBuilder)((PortBuilder)((PortBuilder)new PortBuilder().withContainerPort(this.extractPortFromConfig())).withName("http")).withHostPort(Integer.valueOf(80))).build();
    }

    default public Integer extractPortFromConfig() {
        Map http;
        Map thorntail;
        Map config = this.getThorntailConfig();
        if (config.containsKey("swarm") && !config.containsKey("thorntail")) {
            config.put("thorntail", config.get("swarm"));
        }
        if (config.containsKey("thorntail") && config.get("thorntail") instanceof Map && (thorntail = (Map)config.get("thorntail")).containsKey("http") && thorntail.get("http") instanceof Map && (http = (Map)thorntail.get("http")).containsKey("port")) {
            Object port = http.get("port");
            if (port instanceof Integer) {
                return (Integer)port;
            }
            return Integer.valueOf(port.toString());
        }
        return 8080;
    }
}

