/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.thorntail;

import io.dekorate.ConfigurationRegistry;
import io.dekorate.Session;
import io.dekorate.config.AdditionalResourcesLocator;
import io.dekorate.doc.Description;
import io.dekorate.kubernetes.config.Configurator;
import io.dekorate.processor.AbstractAnnotationProcessor;
import io.dekorate.thorntail.ThorntailWebAnnotationGenerator;
import io.dekorate.thorntail.configurator.ThorntailPrometheusAgentConfigurator;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@Description(value="Detects JAX-RS and servlet annotations and registers the http port.")
@SupportedAnnotationTypes(value={"javax.ws.rs.ApplicationPath", "javax.ws.rs.Path", "javax.servlet.annotation.WebServlet"})
public class ThorntailProcessor
extends AbstractAnnotationProcessor
implements ThorntailWebAnnotationGenerator {
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Session session = this.getSession();
        session.getConfigurationRegistry().add((Configurator)new ThorntailPrometheusAgentConfigurator());
        if (roundEnv.processingOver()) {
            session.close();
            return true;
        }
        ArrayList<String> resourceNames = new ArrayList<String>();
        resourceNames.add("project-defaults.yml");
        resourceNames.addAll(AdditionalResourcesLocator.getAdditionalResources());
        session.addPropertyConfiguration(this.readProperties(resourceNames));
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                this.add(element);
            }
        }
        return false;
    }

    public ConfigurationRegistry getConfigurationRegistry() {
        return Session.getSession().getConfigurationRegistry();
    }
}

