/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.thorntail;

import io.dekorate.Generator;
import io.dekorate.Session;
import io.dekorate.WithSession;
import io.dekorate.kubernetes.config.Configurator;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.PortBuilder;
import io.dekorate.kubernetes.configurator.AddPort;
import io.dekorate.kubernetes.configurator.SetPortPath;
import io.dekorate.thorntail.ThorntailConfigHolder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.servlet.annotation.WebServlet;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Path;

public interface ThorntailWebAnnotationGenerator
extends Generator,
WithSession,
ThorntailConfigHolder {
    default public void add(Element element) {
        final ApplicationPath applicationPath = element.getAnnotation(ApplicationPath.class);
        if (applicationPath != null) {
            HashMap<String, 1> map = new HashMap<String, 1>();
            map.put(ApplicationPath.class.getName(), new HashMap<String, String>(){
                {
                    this.put("value", applicationPath.value());
                }
            });
            this.add(map);
        }
        if (element.getAnnotation(Path.class) != null) {
            this.add(Collections.emptyMap());
        }
        if (element.getAnnotation(WebServlet.class) != null) {
            this.add(Collections.emptyMap());
        }
    }

    default public void add(Map map) {
        Map applicationPath;
        Session session = this.getSession();
        Port port = this.detectHttpPort();
        session.configurators().add((Configurator)new AddPort(port));
        if (map.containsKey(ApplicationPath.class.getName()) && (applicationPath = this.propertiesMap(map, ApplicationPath.class)) != null && applicationPath.containsKey("value")) {
            String path = String.valueOf(applicationPath.get("value"));
            session.configurators().add((Configurator)new SetPortPath(port.getName(), path));
        }
    }

    default public Port detectHttpPort() {
        return ((PortBuilder)((PortBuilder)new PortBuilder().withContainerPort(this.extractPortFromConfig().intValue())).withName("http")).build();
    }

    default public Integer extractPortFromConfig() {
        Map http;
        Map thorntail;
        Map config = this.getThorntailConfig();
        if (config.containsKey("swarm") && !config.containsKey("thorntail")) {
            config.put("thorntail", config.get("swarm"));
        }
        if (config.containsKey("thorntail") && config.get("thorntail") instanceof Map && (thorntail = (Map)config.get("thorntail")).containsKey("http") && thorntail.get("http") instanceof Map && (http = (Map)thorntail.get("http")).containsKey("port")) {
            Object port = http.get("port");
            if (port instanceof Integer) {
                return (Integer)port;
            }
            return Integer.valueOf(port.toString());
        }
        return 8080;
    }
}

