package io.dekorate.spring.config;

import io.dekorate.kubernetes.config.ConfigKey;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.dekorate.project.Project;
import io.dekorate.project.ProjectBuilder;
import io.dekorate.project.ProjectFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SpringApplicationConfigFluent<A extends SpringApplicationConfigFluent<A>> extends BaseFluent<A>{
  public SpringApplicationConfigFluent() {
  }
  
  public SpringApplicationConfigFluent(SpringApplicationConfig instance) {
    this.copyInstance(instance);
  }
  private ProjectBuilder project;
  private Map<ConfigKey,Object> attributes = new LinkedHashMap<ConfigKey,Object>();
  
  protected void copyInstance(SpringApplicationConfig instance) {
    instance = (instance != null ? instance : new SpringApplicationConfig());
    if (instance != null) {
          this.withProject(instance.getProject());
          this.withAttributes(instance.getAttributes());
        }
  }
  
  public Project buildProject() {
    return this.project != null ? this.project.build() : null;
  }
  
  public A withProject(Project project) {
    this._visitables.remove("project");
    if (project != null) {
        this.project = new ProjectBuilder(project);
        this._visitables.get("project").add(this.project);
    } else {
        this.project = null;
        this._visitables.get("project").remove(this.project);
    }
    return (A) this;
  }
  
  public boolean hasProject() {
    return this.project != null;
  }
  
  public ProjectNested<A> withNewProject() {
    return new ProjectNested(null);
  }
  
  public ProjectNested<A> withNewProjectLike(Project item) {
    return new ProjectNested(item);
  }
  
  public ProjectNested<A> editProject() {
    return withNewProjectLike(java.util.Optional.ofNullable(buildProject()).orElse(null));
  }
  
  public ProjectNested<A> editOrNewProject() {
    return withNewProjectLike(java.util.Optional.ofNullable(buildProject()).orElse(new ProjectBuilder().build()));
  }
  
  public ProjectNested<A> editOrNewProjectLike(Project item) {
    return withNewProjectLike(java.util.Optional.ofNullable(buildProject()).orElse(item));
  }
  
  public A addToAttributes(ConfigKey key,Object value) {
    if(this.attributes == null && key != null && value != null) { this.attributes = new LinkedHashMap(); }
    if(key != null && value != null) {this.attributes.put(key, value);} return (A)this;
  }
  
  public A addToAttributes(Map<ConfigKey,Object> map) {
    if(this.attributes == null && map != null) { this.attributes = new LinkedHashMap(); }
    if(map != null) { this.attributes.putAll(map);} return (A)this;
  }
  
  public A removeFromAttributes(ConfigKey key) {
    if(this.attributes == null) { return (A) this; }
    if(key != null && this.attributes != null) {this.attributes.remove(key);} return (A)this;
  }
  
  public A removeFromAttributes(Map<ConfigKey,Object> map) {
    if(this.attributes == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.attributes != null){this.attributes.remove(key);}}} return (A)this;
  }
  
  public Map<ConfigKey,Object> getAttributes() {
    return this.attributes;
  }
  
  public <K,V>A withAttributes(Map<ConfigKey,Object> attributes) {
    if (attributes == null) {
      this.attributes = null;
    } else {
      this.attributes = new LinkedHashMap(attributes);
    }
    return (A) this;
  }
  
  public boolean hasAttributes() {
    return this.attributes != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SpringApplicationConfigFluent that = (SpringApplicationConfigFluent) o;
    if (!java.util.Objects.equals(project, that.project)) return false;
    if (!java.util.Objects.equals(attributes, that.attributes)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(project,  attributes,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (project != null) { sb.append("project:"); sb.append(project + ","); }
    if (attributes != null && !attributes.isEmpty()) { sb.append("attributes:"); sb.append(attributes); }
    sb.append("}");
    return sb.toString();
  }
  public class ProjectNested<N> extends ProjectFluent<ProjectNested<N>> implements Nested<N>{
    ProjectNested(Project item) {
      this.builder = new ProjectBuilder(this, item);
    }
    ProjectBuilder builder;
    
    public N and() {
      return (N) SpringApplicationConfigFluent.this.withProject(builder.build());
    }
    
    public N endProject() {
      return and();
    }
    
  
  }

}