/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.spring;

import io.dekorate.WithProject;
import io.dekorate.utils.Maps;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public interface SpringPropertiesHolder
extends WithProject {
    public static final AtomicReference<Map<String, Object>> springProperties = new AtomicReference<Object>(null);

    default public Map<String, Object> getSpringProperties() {
        if (springProperties.get() == null) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            try {
                FileInputStream appPropsIs = new FileInputStream(this.getProject().getBuildInfo().getResourceDir().resolve("application.properties").toFile());
                properties.putAll(Maps.parseResourceFile((InputStream)appPropsIs, (String)"application.properties"));
                FileInputStream appYamlIs = new FileInputStream(this.getProject().getBuildInfo().getResourceDir().resolve("application.yaml").toFile());
                properties.putAll(Maps.parseResourceFile((InputStream)appYamlIs, (String)"application.yaml"));
                FileInputStream appYmlIs = new FileInputStream(this.getProject().getBuildInfo().getResourceDir().resolve("application.yml").toFile());
                properties.putAll(Maps.parseResourceFile((InputStream)appYmlIs, (String)"application.yml"));
                springProperties.set(properties);
            }
            catch (FileNotFoundException e) {
                return properties;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return springProperties.get();
    }
}

