/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.spring.generator;

import io.dekorate.ConfigurationGenerator;
import io.dekorate.Logger;
import io.dekorate.LoggerFactory;
import io.dekorate.ManifestGenerator;
import io.dekorate.Session;
import io.dekorate.WithSession;
import io.dekorate.config.ConfigurationSupplier;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.kubernetes.config.Configurator;
import io.dekorate.kubernetes.config.Probe;
import io.dekorate.kubernetes.config.ProbeBuilder;
import io.dekorate.kubernetes.configurator.AddLivenessProbeConfigurator;
import io.dekorate.kubernetes.configurator.AddReadinessProbeConfigurator;
import io.dekorate.kubernetes.decorator.AddRoleBindingResourceDecorator;
import io.dekorate.kubernetes.decorator.AddServiceAccountResourceDecorator;
import io.dekorate.kubernetes.decorator.ApplyServiceAccountNamedDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.prometheus.config.EditableServiceMonitorConfig;
import io.dekorate.prometheus.decorator.EndpointPathDecorator;
import io.dekorate.spring.config.SpringApplicationConfig;
import io.dekorate.spring.config.SpringApplicationConfigBuilder;
import io.dekorate.spring.configurator.SetSpringBootRuntime;
import io.dekorate.spring.configurator.SetSpringBootVersion;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Collections;
import java.util.Map;

public interface SpringBootApplicationGenerator
extends ConfigurationGenerator,
WithSession {
    public static final Map<String, Object> SPRING_BOOT_APPLICATION = Collections.emptyMap();
    public static final Logger LOGGER = LoggerFactory.getLogger();

    default public void addAnnotationConfiguration(Map map) {
        this.addConfiguration(map);
    }

    default public void addPropertyConfiguration(Map map) {
        this.addConfiguration(map);
    }

    default public void addConfiguration(Map map) {
        final Session session = this.getSession();
        session.getConfigurationRegistry().add(new ConfigurationSupplier((VisitableBuilder)new SpringApplicationConfigBuilder()));
        session.getConfigurationRegistry().add((Configurator)new SetSpringBootRuntime());
        session.getConfigurationRegistry().add((Configurator)new SetSpringBootVersion());
        session.getHandlers().add(new ManifestGenerator(){

            public int order() {
                return 410;
            }

            public String getKey() {
                return "spring";
            }

            public void handle(Configuration config) {
                LOGGER.info("Processing service monitor config.");
                session.getResourceRegistry().decorate((Decorator)new EndpointPathDecorator("http", "/actuator/prometheus"));
            }

            public boolean canHandle(Class config) {
                return SpringApplicationConfig.class.equals((Object)config) || EditableServiceMonitorConfig.class.equals((Object)config);
            }
        });
        if (this.isActuatorAvailable()) {
            session.getConfigurationRegistry().add((Configurator)new AddLivenessProbeConfigurator((Probe)((ProbeBuilder)new ProbeBuilder().withHttpActionPath("/actuator/info")).build(), false));
            session.getConfigurationRegistry().add((Configurator)new AddReadinessProbeConfigurator((Probe)((ProbeBuilder)new ProbeBuilder().withHttpActionPath("/actuator/health")).build(), false));
        }
        if (this.isSpringCloudKubernetesAvailable()) {
            session.getHandlers().add(new ManifestGenerator(){

                public int order() {
                    return 310;
                }

                public String getKey() {
                    return "spring";
                }

                public void handle(Configuration config) {
                    LOGGER.info("Detected spring cloud kubernetes.");
                    session.getResourceRegistry().decorate((Decorator)new ApplyServiceAccountNamedDecorator());
                    session.getResourceRegistry().decorate((Decorator)new AddServiceAccountResourceDecorator());
                    session.getResourceRegistry().decorate((Decorator)new AddRoleBindingResourceDecorator("view"));
                }

                public boolean canHandle(Class config) {
                    return SpringApplicationConfig.class.isAssignableFrom(config);
                }
            });
        }
    }

    default public boolean isActuatorAvailable() {
        try {
            Class<?> c = Class.forName("org.springframework.boot.actuate.health.HealthIndicator");
            return c != null;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
    }

    default public boolean isSpringCloudKubernetesAvailable() {
        try {
            Class<?> c = Class.forName("org.springframework.cloud.kubernetes.KubernetesAutoConfiguration");
            return c != null;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
    }
}

