/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.spring.generator;

import io.dekorate.Generator;
import io.dekorate.Session;
import io.dekorate.kubernetes.config.Configurator;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.PortBuilder;
import io.dekorate.kubernetes.configurator.ApplyPort;
import io.dekorate.spring.SpringPropertiesHolder;
import io.dekorate.utils.Ports;
import java.util.Collections;
import java.util.Map;

public interface SpringBootWebAnnotationGenerator
extends Generator,
SpringPropertiesHolder {
    public static final String DEKORATE_SPRING_WEB_PATH = "dekorate.spring.web.path";
    public static final Map WEB_ANNOTATIONS = Collections.emptyMap();

    default public void addAnnotationConfiguration(Map map) {
        this.addConfiguration(map);
    }

    default public void addPropertyConfiguration(Map map) {
        this.addConfiguration(map);
    }

    default public void addConfiguration(Map map) {
        Session session = this.getSession();
        Port port = this.detectHttpPort(map);
        session.configurators().add((Configurator)new ApplyPort(port, Ports.webPortNames()));
    }

    default public Port detectHttpPort(Map map) {
        return ((PortBuilder)((PortBuilder)((PortBuilder)((PortBuilder)new PortBuilder().withName("http")).withHostPort(80)).withContainerPort(this.extractPortFromProperties().intValue())).withPath(String.valueOf(map.getOrDefault(DEKORATE_SPRING_WEB_PATH, "/")))).build();
    }

    default public Integer extractPortFromProperties() {
        Map serverProperties;
        Object port;
        Object server = this.getSpringProperties().get("server");
        if (server != null && Map.class.isAssignableFrom(server.getClass()) && (port = (serverProperties = (Map)server).get("port")) != null) {
            return port instanceof Integer ? (Integer)port : Integer.valueOf(port.toString());
        }
        return 8080;
    }
}

