/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.spring.apt;

import io.dekorate.Logger;
import io.dekorate.LoggerFactory;
import io.dekorate.doc.Description;
import io.dekorate.processor.AbstractAnnotationProcessor;
import io.dekorate.spring.generator.SpringBootWebAnnotationGenerator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

@Description(value="Detects Spring Boot web endpoints and registers the http port.")
@SupportedAnnotationTypes(value={"org.springframework.web.bind.annotation.RestController", "org.springframework.web.bind.annotation.RequestMapping", "org.springframework.web.bind.annotation.GetMapping", "org.springframework.data.rest.core.annotation.RepositoryRestResource", "javax.ws.rs.GET", "javax.ws.rs.POST", "javax.ws.rs.PUT", "javax.ws.rs.DELETE", "javax.ws.rs.OPTIONS", "javax.ws.rs.HEAD", "javax.ws.rs.PATCH"})
public class SpringBootWebProcessor
extends AbstractAnnotationProcessor
implements SpringBootWebAnnotationGenerator {
    private final Logger LOGGER = LoggerFactory.getLogger();
    private static final String REQUESTMAPPING = "RequestMapping";
    private static final Set<String> PATH_METHODS = new HashSet<String>(){
        {
            this.add("value");
            this.add("path");
        }
    };

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.getSession().close();
            return true;
        }
        HashSet<String> paths = new HashSet<String>();
        for (TypeElement typeElement : annotations) {
            if (!typeElement.getSimpleName().toString().endsWith("RestController")) continue;
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                if (!(element instanceof TypeElement)) continue;
                Set detectedPaths = element.getAnnotationMirrors().stream().filter(a -> a.getAnnotationType().toString().contains(REQUESTMAPPING)).flatMap(a -> a.getElementValues().entrySet().stream()).filter(e -> PATH_METHODS.contains(((ExecutableElement)e.getKey()).getSimpleName().toString())).map(p -> ((AnnotationValue)p.getValue()).getValue().toString().replace('\"', ' ').trim()).collect(Collectors.toSet());
                if (detectedPaths.isEmpty()) {
                    paths.add("/");
                    continue;
                }
                paths.addAll(detectedPaths);
            }
        }
        this.LOGGER.info("Found Spring web annotation!");
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("dekorate.spring.web.path", SpringBootWebProcessor.findShortedCommonPath(paths));
        this.addAnnotationConfiguration(config);
        return false;
    }

    public static String findShortedCommonPath(Set<String> paths) {
        String longestPath;
        if (paths.isEmpty()) {
            return "/";
        }
        String shortedPath = longestPath = paths.stream().sorted(Comparator.comparingInt(String::length).reversed()).findFirst().orElseThrow(IllegalStateException::new);
        for (String p : paths) {
            if (shortedPath.startsWith(p)) {
                shortedPath = p;
                continue;
            }
            if (p.startsWith(shortedPath)) continue;
            return "/";
        }
        return shortedPath;
    }
}

