/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.spring.apt;

import io.dekorate.Session;
import io.dekorate.doc.Description;
import io.dekorate.processor.AbstractAnnotationProcessor;
import io.dekorate.spring.BeanListener;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

@Description(value="Detects Spring Boot and set the runtime attribute to Spring Boot.")
@SupportedAnnotationTypes(value={"org.springframework.context.annotation.Bean"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class SpringBootBeanProcessor
extends AbstractAnnotationProcessor {
    private Map<String, BeanListener> listeners = new HashMap<String, BeanListener>();

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Session session = Session.getSession();
        if (roundEnv.processingOver()) {
            session.close();
            return true;
        }
        this.registerListeners();
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                TypeElement te;
                String fqcn;
                BeanListener listener;
                if (!(element instanceof ExecutableElement)) continue;
                ExecutableElement executableElement = (ExecutableElement)element;
                TypeMirror typeMirror = executableElement.getReturnType();
                Element el = this.processingEnv.getTypeUtils().asElement(typeMirror);
                if (!(el instanceof TypeElement) || (listener = this.listeners.get(fqcn = (te = (TypeElement)el).getQualifiedName().toString())) == null) continue;
                listener.onBean();
            }
        }
        return false;
    }

    private void registerListeners() {
        if (this.listeners.isEmpty()) {
            ServiceLoader<BeanListener> serviceLoader = ServiceLoader.load(BeanListener.class, BeanListener.class.getClassLoader());
            for (BeanListener listener : serviceLoader) {
                this.listeners.put(listener.getType(), listener);
            }
        }
    }
}

