/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.spring.generator;

import io.dekorate.Generator;
import io.dekorate.Handler;
import io.dekorate.WithSession;
import io.dekorate.config.ConfigurationSupplier;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.kubernetes.config.Configurator;
import io.dekorate.kubernetes.config.Probe;
import io.dekorate.kubernetes.config.ProbeBuilder;
import io.dekorate.kubernetes.decorator.AddLivenessProbeDecorator;
import io.dekorate.kubernetes.decorator.AddReadinessProbeDecorator;
import io.dekorate.kubernetes.decorator.AddRoleBindingDecorator;
import io.dekorate.kubernetes.decorator.AddServiceAccountDecorator;
import io.dekorate.kubernetes.decorator.ApplyServiceAccountDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.prometheus.config.EditableServiceMonitorConfig;
import io.dekorate.prometheus.decorator.EndpointPathDecorator;
import io.dekorate.spring.config.SpringApplicationConfig;
import io.dekorate.spring.config.SpringApplicationConfigBuilder;
import io.dekorate.spring.configurator.SetSpringBootRuntime;
import io.dekorate.spring.configurator.SetSpringBootVersion;
import java.util.Collections;
import java.util.Map;

public interface SpringBootApplicationGenerator
extends Generator,
WithSession {
    public static final Map<String, Object> SPRING_BOOT_APPLICATION = Collections.emptyMap();

    default public void add(Map map) {
        session.configurators().add(new ConfigurationSupplier((VisitableBuilder)new SpringApplicationConfigBuilder()));
        session.handlers().add(new Handler(){

            public int order() {
                return 600;
            }

            public void handle(Configuration config) {
                WithSession.session.configurators().add((Configurator)new SetSpringBootRuntime());
                WithSession.session.configurators().add((Configurator)new SetSpringBootVersion());
            }

            public boolean canHandle(Class config) {
                return Configuration.class.isAssignableFrom(config);
            }
        });
        session.handlers().add(new Handler(){

            public int order() {
                return 410;
            }

            public void handle(Configuration config) {
                WithSession.session.resources().decorate((Decorator)new EndpointPathDecorator(WithSession.session.resources().getName(), "http", "/actuator/prometheus"));
            }

            public boolean canHandle(Class config) {
                return SpringApplicationConfig.class.equals((Object)config) || EditableServiceMonitorConfig.class.equals((Object)config);
            }
        });
        if (this.isActuatorAvailable()) {
            session.handlers().add(new Handler(){

                public int order() {
                    return 305;
                }

                public void handle(Configuration config) {
                    WithSession.session.resources().decorate((Decorator)new AddLivenessProbeDecorator(WithSession.session.resources().getName(), WithSession.session.resources().getName(), (Probe)((ProbeBuilder)new ProbeBuilder().withHttpActionPath("/actuator/health")).build()));
                    WithSession.session.resources().decorate((Decorator)new AddReadinessProbeDecorator(WithSession.session.resources().getName(), WithSession.session.resources().getName(), (Probe)((ProbeBuilder)new ProbeBuilder().withHttpActionPath("/actuator/health")).build()));
                }

                public boolean canHandle(Class config) {
                    return SpringApplicationConfig.class.isAssignableFrom(config);
                }
            });
        }
        if (this.isSpringCloudKubernetesAvailable()) {
            session.handlers().add(new Handler(){

                public int order() {
                    return 310;
                }

                public void handle(Configuration config) {
                    WithSession.session.resources().decorate((Decorator)new ApplyServiceAccountDecorator(WithSession.session.resources().getName(), WithSession.session.resources().getName()));
                    WithSession.session.resources().decorate((Decorator)new AddServiceAccountDecorator(WithSession.session.resources()));
                    WithSession.session.resources().decorate((Decorator)new AddRoleBindingDecorator(WithSession.session.resources(), "view"));
                }

                public boolean canHandle(Class config) {
                    return SpringApplicationConfig.class.isAssignableFrom(config);
                }
            });
        }
    }

    default public boolean isActuatorAvailable() {
        try {
            Class<?> c = Class.forName("org.springframework.boot.actuate.health.HealthIndicator");
            return c != null;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
    }

    default public boolean isSpringCloudKubernetesAvailable() {
        try {
            Class<?> c = Class.forName("org.springframework.cloud.kubernetes.KubernetesAutoConfiguration");
            return c != null;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
    }
}

