/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.spring.apt;

import io.dekorate.Generator;
import io.dekorate.Session;
import io.dekorate.doc.Description;
import io.dekorate.processor.AbstractAnnotationProcessor;
import io.dekorate.spring.generator.SpringBootApplicationGenerator;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;

@Description(value="Detects Spring Boot and set the runtime attribute to Spring Boot.")
@SupportedAnnotationTypes(value={"org.springframework.boot.autoconfigure.SpringBootApplication"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class SpringBootApplicationProcessor
extends AbstractAnnotationProcessor
implements SpringBootApplicationGenerator {
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Session session = Session.getSession();
        if (roundEnv.processingOver()) {
            session.close();
            return true;
        }
        Generator.init((Map)this.readApplicationConfig(new String[]{"application.properties", "application.yaml", "application.yml", "application-kubernetes.properties", "application-kubernetes.yaml", "application-kubernetes.yml"}));
        this.add(SPRING_BOOT_APPLICATION);
        return false;
    }
}

