package io.dekorate.spring.config;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SpringApplicationConfigBuilder extends SpringApplicationConfigFluentImpl<SpringApplicationConfigBuilder> implements VisitableBuilder<SpringApplicationConfig,SpringApplicationConfigBuilder> {

    SpringApplicationConfigFluent<?> fluent;
    Boolean validationEnabled;

    public SpringApplicationConfigBuilder() { 
        this(true);
    }


    public SpringApplicationConfigBuilder(Boolean validationEnabled) { 
        this(new SpringApplicationConfig(), validationEnabled);
    }


    public SpringApplicationConfigBuilder(SpringApplicationConfigFluent<?> fluent) { 
        this(fluent, true);
    }


    public SpringApplicationConfigBuilder(SpringApplicationConfigFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new SpringApplicationConfig(), validationEnabled);
    }


    public SpringApplicationConfigBuilder(SpringApplicationConfigFluent<?> fluent,SpringApplicationConfig instance) { 
        this(fluent, instance, true);
    }


    public SpringApplicationConfigBuilder(SpringApplicationConfigFluent<?> fluent,SpringApplicationConfig instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        this.validationEnabled = validationEnabled; 
    }


    public SpringApplicationConfigBuilder(SpringApplicationConfig instance) { 
        this(instance,true);
    }


    public SpringApplicationConfigBuilder(SpringApplicationConfig instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.validationEnabled = validationEnabled; 
    }


    public io.dekorate.spring.config.EditableSpringApplicationConfig build() {
        EditableSpringApplicationConfig buildable = new EditableSpringApplicationConfig();
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SpringApplicationConfigBuilder that = (SpringApplicationConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
