/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.spring.generator;

import io.dekorate.Generator;
import io.dekorate.Session;
import io.dekorate.WithSession;
import io.dekorate.kubernetes.config.Configurator;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.PortBuilder;
import io.dekorate.kubernetes.configurator.AddPort;
import io.dekorate.spring.SpringPropertiesHolder;
import java.util.Collections;
import java.util.Map;

public interface SpringBootWebAnnotationGenerator
extends Generator,
WithSession,
SpringPropertiesHolder {
    public static final Map WEB_ANNOTATIONS = Collections.emptyMap();

    default public void add(Map map) {
        Session session = this.getSession();
        Port port = this.detectHttpPort();
        session.configurators().add((Configurator)new AddPort(port));
    }

    default public Port detectHttpPort() {
        return ((PortBuilder)((PortBuilder)new PortBuilder().withContainerPort(this.extractPortFromProperties().intValue())).withName("http")).build();
    }

    default public Integer extractPortFromProperties() {
        Map serverProperties;
        Object port;
        Object server = this.getSpringProperties().get("server");
        if (server != null && Map.class.isAssignableFrom(server.getClass()) && (port = (serverProperties = (Map)server).get("port")) != null) {
            return port instanceof Integer ? (Integer)port : Integer.valueOf(port.toString());
        }
        return 8080;
    }
}

