/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.crd.apt;

import io.dekorate.config.ConfigurationSupplier;
import io.dekorate.config.MultiConfiguration;
import io.dekorate.crd.annotation.Autodetect;
import io.dekorate.crd.annotation.Crd;
import io.dekorate.crd.config.CustomResourceConfigBuilder;
import io.dekorate.crd.config.Keys;
import io.dekorate.crd.config.Scope;
import io.dekorate.crd.configurator.AddClassNameConfigurator;
import io.dekorate.crd.generator.CustomResourceGenerator;
import io.dekorate.processor.AbstractAnnotationProcessor;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Kind;
import io.fabric8.kubernetes.model.annotation.Plural;
import io.fabric8.kubernetes.model.annotation.Singular;
import io.fabric8.kubernetes.model.annotation.Version;
import io.sundr.codegen.CodegenContext;
import io.sundr.codegen.functions.ElementTo;
import io.sundr.codegen.model.TypeDef;
import io.sundr.codegen.utils.ModelUtils;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

@SupportedAnnotationTypes(value={"io.fabric8.kubernetes.model.annotation.Group", "io.fabric8.kubernetes.model.annotation.Version", "io.fabric8.kubernetes.model.annotation.Kind", "io.fabric8.kubernetes.model.annotation.Plural", "io.fabric8.kubernetes.model.annotation.Singular", "io.dekorate.crd.annotation.Crd"})
public class CustomResourceAnnotationProcessor
extends AbstractAnnotationProcessor
implements CustomResourceGenerator {
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.getSession().close();
            return true;
        }
        CodegenContext.create((Elements)this.processingEnv.getElementUtils(), (Types)this.processingEnv.getTypeUtils());
        LinkedHashSet<TypeElement> annotatedTypes = new LinkedHashSet<TypeElement>();
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                if (!(element instanceof TypeElement)) continue;
                annotatedTypes.add((TypeElement)element);
            }
        }
        for (TypeElement typeElement : annotatedTypes) {
            this.add(typeElement);
        }
        return false;
    }

    public static <T> T firstOf(Optional<T> ... optionals) {
        return Arrays.stream(optionals).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(null);
    }

    public void add(Element element) {
        String statusClassName;
        Optional<Crd> crd = Optional.ofNullable(element.getAnnotation(Crd.class));
        Optional<Group> group = Optional.ofNullable(element.getAnnotation(Group.class));
        Optional<Version> version = Optional.ofNullable(element.getAnnotation(Version.class));
        Optional<Kind> kind = Optional.ofNullable(element.getAnnotation(Kind.class));
        Optional<Plural> plural = Optional.ofNullable(element.getAnnotation(Plural.class));
        Optional<Singular> singular = Optional.ofNullable(element.getAnnotation(Singular.class));
        try {
            statusClassName = crd.map(Crd::status).map(Class::getCanonicalName).orElse(Autodetect.class.getCanonicalName());
        }
        catch (MirroredTypeException e) {
            statusClassName = e.getTypeMirror().toString();
        }
        if (element instanceof TypeElement) {
            TypeDef definition = (TypeDef)ElementTo.TYPEDEF.apply((Object)((TypeElement)element));
            String className = ModelUtils.getClassName((Element)element);
            CustomResourceConfigBuilder builder = (CustomResourceConfigBuilder)((CustomResourceConfigBuilder)((CustomResourceConfigBuilder)((CustomResourceConfigBuilder)((CustomResourceConfigBuilder)((CustomResourceConfigBuilder)((CustomResourceConfigBuilder)((CustomResourceConfigBuilder)((CustomResourceConfigBuilder)((CustomResourceConfigBuilder)((CustomResourceConfigBuilder)((CustomResourceConfigBuilder)new CustomResourceConfigBuilder().withKind((String)CustomResourceAnnotationProcessor.firstOf(kind.map(Kind::value), crd.map(Crd::kind)))).withGroup((String)CustomResourceAnnotationProcessor.firstOf(group.map(Group::value), crd.map(Crd::group)))).withVersion((String)CustomResourceAnnotationProcessor.firstOf(version.map(Version::value), crd.map(Crd::version)))).withPlural((String)CustomResourceAnnotationProcessor.firstOf(plural.map(Plural::value), crd.map(Crd::plural)))).withName((String)CustomResourceAnnotationProcessor.firstOf(singular.map(Singular::value), crd.map(Crd::name)))).withScope((Scope)((Object)CustomResourceAnnotationProcessor.firstOf(crd.map(Crd::scope), Optional.of(io.dekorate.crd.util.Types.isNamespaced(definition) ? Scope.Namespaced : Scope.Cluster))))).withServed((Boolean)CustomResourceAnnotationProcessor.firstOf(crd.map(Crd::served), Optional.of(true)))).withStorage((Boolean)CustomResourceAnnotationProcessor.firstOf(crd.map(Crd::storage), Optional.of(false)))).withStatusClassName(statusClassName)).withNewScale().endScale()).accept(new Visitor[]{new AddClassNameConfigurator(className)})).addToAttributes(Keys.TYPE_DEFINITION, definition);
            this.on((ConfigurationSupplier)new MultiConfiguration((VisitableBuilder)builder));
        }
    }
}

