package io.dekorate.crd.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ScaleBuilder extends ScaleFluentImpl<ScaleBuilder> implements VisitableBuilder<Scale,ScaleBuilder> {

    ScaleFluent<?> fluent;
    Boolean validationEnabled;

    public ScaleBuilder() {
        this(true);
    }

    public ScaleBuilder(Boolean validationEnabled) {
        this.fluent = this; this.validationEnabled=validationEnabled;
    }

    public ScaleBuilder(ScaleFluent<?> fluent) {
        this(fluent, true);
    }

    public ScaleBuilder(ScaleFluent<?> fluent,Boolean validationEnabled) {
        this.fluent = fluent; this.validationEnabled=validationEnabled;
    }

    public ScaleBuilder(ScaleFluent<?> fluent,Scale instance) {
        this(fluent, instance, true);
    }

    public ScaleBuilder(ScaleFluent<?> fluent,Scale instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withSpecReplicasPath(instance.getSpecReplicasPath()); 
        fluent.withStatusReplicasPath(instance.getStatusReplicasPath()); 
        fluent.withLabelSelectorPath(instance.getLabelSelectorPath()); 
        this.validationEnabled = validationEnabled; 
    }

    public ScaleBuilder(Scale instance) {
        this(instance,true);
    }

    public ScaleBuilder(Scale instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withSpecReplicasPath(instance.getSpecReplicasPath()); 
        this.withStatusReplicasPath(instance.getStatusReplicasPath()); 
        this.withLabelSelectorPath(instance.getLabelSelectorPath()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.dekorate.crd.config.EditableScale build() {
        EditableScale buildable = new EditableScale(fluent.getSpecReplicasPath(),fluent.getStatusReplicasPath(),fluent.getLabelSelectorPath());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ScaleBuilder that = (ScaleBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
