/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.crd.decorator;

import io.dekorate.crd.decorator.AddCustomResourceDefinitionResourceDecorator;
import io.dekorate.crd.decorator.AddCustomResourceDefintionVersionDecorator;
import io.dekorate.crd.decorator.AddLabelSelectorPathDecorator;
import io.dekorate.crd.decorator.AddSchemaToCustomResourceDefinitionVersionDecorator;
import io.dekorate.crd.decorator.AddSpecReplicasPathDecorator;
import io.dekorate.crd.decorator.AddStatusReplicasPathDecorator;
import io.dekorate.crd.decorator.AddStatusSubresourceDecorator;
import io.dekorate.crd.decorator.AddSubresourcesDecorator;
import io.dekorate.crd.decorator.CustomResourceDefinitionDecorator;
import io.dekorate.crd.decorator.CustomResourceDefinitionVersionDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpecFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceSubresources;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceValidation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class PromoteSingleVersionAttributesDecorator
extends CustomResourceDefinitionDecorator<CustomResourceDefinitionSpecFluent<?>> {
    public PromoteSingleVersionAttributesDecorator(String name) {
        super(name);
    }

    @Override
    public void andThenVisit(CustomResourceDefinitionSpecFluent<?> spec, ObjectMeta resourceMeta) {
        List versions = spec.buildVersions();
        if (versions.size() == 1) {
            CustomResourceDefinitionVersion version = (CustomResourceDefinitionVersion)versions.get(0);
            spec.withSubresources(version.getSubresources()).withValidation(version.getSchema()).withAdditionalPrinterColumns(version.getAdditionalPrinterColumns());
            CustomResourceDefinitionVersion newVersion = new CustomResourceDefinitionVersionBuilder(version).build();
            newVersion.setSubresources(null);
            newVersion.setSchema(null);
            newVersion.setAdditionalPrinterColumns(null);
            spec.removeAllFromVersions((Collection)versions);
            spec.withVersions(new CustomResourceDefinitionVersion[]{newVersion});
        } else {
            Set subresources = versions.stream().map(CustomResourceDefinitionVersion::getSubresources).collect(Collectors.toSet());
            Set additionalPrinterColumns = versions.stream().map(CustomResourceDefinitionVersion::getAdditionalPrinterColumns).collect(Collectors.toSet());
            Set schemas = versions.stream().map(CustomResourceDefinitionVersion::getSchema).collect(Collectors.toSet());
            boolean hasIdenticalSubresources = subresources.size() == 1;
            boolean hasIdenticalAdditionalPrinterColumns = additionalPrinterColumns.size() == 1;
            boolean hasIdenticalSchemas = schemas.size() == 1;
            System.out.printf("Found %s soubresources, %s column list sets, %s schemas ", subresources.size(), additionalPrinterColumns.size(), schemas.size());
            spec.withValidation(hasIdenticalSchemas ? (CustomResourceValidation)schemas.iterator().next() : null).withSubresources(hasIdenticalSubresources ? (CustomResourceSubresources)subresources.iterator().next() : null).withAdditionalPrinterColumns(hasIdenticalAdditionalPrinterColumns ? (List)additionalPrinterColumns.iterator().next() : null);
            spec.removeAllFromVersions((Collection)versions);
            ArrayList<CustomResourceDefinitionVersion> newVersions = new ArrayList<CustomResourceDefinitionVersion>();
            for (CustomResourceDefinitionVersion version : versions) {
                CustomResourceDefinitionVersion newVersion = new CustomResourceDefinitionVersionBuilder(version).build();
                if (hasIdenticalSchemas) {
                    newVersion.setSchema(null);
                }
                if (hasIdenticalSubresources) {
                    newVersion.setSubresources(null);
                }
                if (hasIdenticalAdditionalPrinterColumns) {
                    newVersion.setAdditionalPrinterColumns(null);
                }
                newVersions.add(newVersion);
            }
            spec.withVersions(newVersions);
        }
    }

    public Class<? extends Decorator>[] after() {
        return new Class[]{AddCustomResourceDefinitionResourceDecorator.class, AddCustomResourceDefintionVersionDecorator.class, CustomResourceDefinitionVersionDecorator.class, AddSchemaToCustomResourceDefinitionVersionDecorator.class, AddSubresourcesDecorator.class, AddStatusSubresourceDecorator.class, AddStatusReplicasPathDecorator.class, AddSpecReplicasPathDecorator.class, AddLabelSelectorPathDecorator.class};
    }
}

