/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.crd.decorator;

import io.dekorate.crd.decorator.AddCustomResourceDefinitionResourceDecorator;
import io.dekorate.crd.decorator.AddCustomResourceDefintionVersionDecorator;
import io.dekorate.crd.decorator.CustomResourceDefinitionDecorator;
import io.dekorate.crd.decorator.SetStorageVersionDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpecFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;

public class EnsureSingleStorageVersionDecorator
extends CustomResourceDefinitionDecorator<CustomResourceDefinitionSpecFluent<?>> {
    private final AtomicReference<String> storageVersion = new AtomicReference();

    public EnsureSingleStorageVersionDecorator(String name) {
        super(name);
    }

    @Override
    public void andThenVisit(CustomResourceDefinitionSpecFluent<?> spec, ObjectMeta resourceMeta) {
        Predicate<CustomResourceDefinitionVersionBuilder> hasStorageVersion = new Predicate<CustomResourceDefinitionVersionBuilder>(){

            @Override
            public boolean test(CustomResourceDefinitionVersionBuilder version) {
                return version.isStorage();
            }
        };
        if (spec.hasVersions().booleanValue() && !spec.hasMatchingVersion((Predicate)hasStorageVersion).booleanValue()) {
            ((CustomResourceDefinitionSpecFluent.VersionsNested)spec.editFirstVersion().withStorage(Boolean.valueOf(true))).endVersion();
        }
        for (CustomResourceDefinitionVersion version : spec.buildVersions()) {
            if (!version.getStorage().booleanValue()) continue;
            String existing = this.storageVersion.get();
            if (existing != null && !existing.equals(version.getName())) {
                throw new IllegalStateException(String.format("Version %s is marked as storage and so is %s. Only one version should be marked as storage per custom resource.", version.getName(), existing));
            }
            this.storageVersion.set(version.getName());
        }
    }

    public Class<? extends Decorator>[] after() {
        return new Class[]{AddCustomResourceDefinitionResourceDecorator.class, AddCustomResourceDefintionVersionDecorator.class, SetStorageVersionDecorator.class};
    }
}

