/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.crd.config;

import io.dekorate.crd.config.EditableScale;
import io.dekorate.crd.config.Scale;
import io.dekorate.crd.config.ScaleFluent;
import io.dekorate.crd.config.ScaleFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Objects;

public class ScaleBuilder
extends ScaleFluentImpl<ScaleBuilder>
implements VisitableBuilder<Scale, ScaleBuilder> {
    ScaleFluent<?> fluent;
    Boolean validationEnabled;

    public ScaleBuilder() {
        this(true);
    }

    public ScaleBuilder(Boolean validationEnabled) {
        this.fluent = this;
        this.validationEnabled = validationEnabled;
    }

    public ScaleBuilder(ScaleFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ScaleBuilder(ScaleFluent<?> fluent, Boolean validationEnabled) {
        this.fluent = fluent;
        this.validationEnabled = validationEnabled;
    }

    public ScaleBuilder(ScaleFluent<?> fluent, Scale instance) {
        this(fluent, instance, true);
    }

    public ScaleBuilder(ScaleFluent<?> fluent, Scale instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withSpecReplicasPath(instance.getSpecReplicasPath());
        fluent.withStatusReplicasPath(instance.getStatusReplicasPath());
        fluent.withLabelSelectorPath(instance.getLabelSelectorPath());
        this.validationEnabled = validationEnabled;
    }

    public ScaleBuilder(Scale instance) {
        this(instance, (Boolean)true);
    }

    public ScaleBuilder(Scale instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withSpecReplicasPath(instance.getSpecReplicasPath());
        this.withStatusReplicasPath(instance.getStatusReplicasPath());
        this.withLabelSelectorPath(instance.getLabelSelectorPath());
        this.validationEnabled = validationEnabled;
    }

    public EditableScale build() {
        EditableScale buildable = new EditableScale(this.fluent.getSpecReplicasPath(), this.fluent.getStatusReplicasPath(), this.fluent.getLabelSelectorPath());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScaleBuilder that = (ScaleBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

