/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.crd.visitor;

import io.sundr.builder.TypedVisitor;
import io.sundr.builder.Visitor;
import io.sundr.codegen.model.ClassRef;
import io.sundr.codegen.model.EditableTypeDef;
import io.sundr.codegen.model.Property;
import io.sundr.codegen.model.TypeDef;
import io.sundr.codegen.model.TypeDefBuilder;
import io.sundr.codegen.utils.TypeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class AnnotatedMultiPropertyPathDetector
extends TypedVisitor<TypeDefBuilder> {
    protected static final String DOT = ".";
    protected static final String STATUS = ".status.";
    private final String prefix;
    private final String annotationName;
    private final List<Property> parents;
    private final Map<String, Property> properties;

    public AnnotatedMultiPropertyPathDetector(String prefix, String annotationName) {
        this(prefix, annotationName, new ArrayList<Property>());
    }

    public AnnotatedMultiPropertyPathDetector(String prefix, String annotationName, List<Property> parents) {
        this(prefix, annotationName, parents, new HashMap<String, Property>());
    }

    public AnnotatedMultiPropertyPathDetector(String prefix, String annotationName, List<Property> parents, Map<String, Property> properties) {
        this.prefix = prefix;
        this.annotationName = annotationName;
        this.parents = parents;
        this.properties = properties;
    }

    public void visit(TypeDefBuilder builder) {
        EditableTypeDef type = builder.build();
        for (Property p2 : TypeUtils.allProperties((TypeDef)type)) {
            if (this.parents.contains(p2)) continue;
            ArrayList<Property> newParents = new ArrayList<Property>(this.parents);
            boolean match = p2.getAnnotations().stream().anyMatch(a -> a.getClassRef().getName().equals(this.annotationName));
            if (!match) continue;
            newParents.add(p2);
            this.properties.put(newParents.stream().map(Property::getName).collect(Collectors.joining(DOT, this.prefix, "")), p2);
        }
        TypeUtils.allProperties((TypeDef)type).stream().filter(p -> p.getTypeRef() instanceof ClassRef).forEach(p -> {
            if (!this.parents.contains(p)) {
                ClassRef classRef = (ClassRef)p.getTypeRef();
                TypeDef propertyType = classRef.getDefinition();
                ArrayList<Property> newParents = new ArrayList<Property>(this.parents);
                newParents.add((Property)p);
                ((TypeDefBuilder)new TypeDefBuilder(propertyType).accept(new Visitor[]{new AnnotatedMultiPropertyPathDetector(this.prefix, this.annotationName, newParents, this.properties)})).build();
            }
        });
    }

    public Set<String> getPaths() {
        return this.properties.keySet();
    }

    public Map<String, Property> getProperties() {
        return this.properties;
    }
}

